/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.serialize.EnumSerializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.kryo.serialize.SimpleSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Iterator;

public class EnumSetSerializer
extends SimpleSerializer<EnumSet> {
    private static final Field TYPE_FIELD;
    private final Kryo _kryo;

    public EnumSetSerializer(Kryo kryo) {
        this._kryo = kryo;
    }

    public EnumSet read(ByteBuffer buffer) {
        Class elementType = this._kryo.readClass(buffer).getType();
        EnumSet<Object> result = EnumSet.noneOf(elementType);
        int size = IntSerializer.get((ByteBuffer)buffer, (boolean)true);
        for (int i = 0; i < size; ++i) {
            result.add(EnumSerializer.get((ByteBuffer)buffer, (Class)elementType));
        }
        return result;
    }

    public void write(ByteBuffer buffer, EnumSet set) {
        this._kryo.writeClass(buffer, this.getElementType(set));
        IntSerializer.put((ByteBuffer)buffer, (int)set.size(), (boolean)true);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            EnumSerializer.put((ByteBuffer)buffer, (Enum)((Enum)iter.next()));
        }
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Wrote EnumSet: " + set));
        }
    }

    private Class getElementType(EnumSet<? extends Enum<?>> set) {
        try {
            return (Class)TYPE_FIELD.get(set);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not access keys field.", e);
        }
    }

    static {
        try {
            TYPE_FIELD = EnumSet.class.getDeclaredField("elementType");
            TYPE_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("The EnumSet class seems to have changed, could not access expected field.", e);
        }
    }
}

