/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer.lwjgl;

import de.javagl.jgltf.viewer.AbstractGltfViewer;
import de.javagl.jgltf.viewer.GlContext;
import de.javagl.jgltf.viewer.lwjgl.GlContextLwjgl;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.GL11;

public class GltfViewerLwjgl
extends AbstractGltfViewer<Component> {
    private static final Logger logger = Logger.getLogger(GltfViewerLwjgl.class.getName());
    private Component glComponent;
    private final GlContextLwjgl glContext;
    private boolean viewportNeedsUpdate = true;

    public GltfViewerLwjgl() {
        try {
            this.glComponent = new AWTGLCanvas(){
                private static final long serialVersionUID = 1L;

                public void paintGL() {
                    if (GltfViewerLwjgl.this.viewportNeedsUpdate) {
                        GL11.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
                        GltfViewerLwjgl.this.viewportNeedsUpdate = false;
                    }
                    GltfViewerLwjgl.this.doRender();
                    try {
                        this.swapBuffers();
                    }
                    catch (LWJGLException e) {
                        logger.severe("Could not swap buffers");
                    }
                }
            };
            this.glComponent.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    GltfViewerLwjgl.this.viewportNeedsUpdate = true;
                }
            });
        }
        catch (LWJGLException e) {
            logger.severe("Could not create AWTGLCanvas");
            this.glComponent = new Canvas();
        }
        this.glComponent.setMinimumSize(new Dimension(10, 10));
        this.glContext = new GlContextLwjgl();
    }

    public GlContext getGlContext() {
        return this.glContext;
    }

    public Component getRenderComponent() {
        return this.glComponent;
    }

    public int getWidth() {
        return this.glComponent.getWidth();
    }

    public int getHeight() {
        return this.glComponent.getHeight();
    }

    public void triggerRendering() {
        if (this.getRenderComponent() != null) {
            this.getRenderComponent().repaint();
        }
    }

    protected void prepareRender() {
    }

    protected void render() {
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
        GL11.glClear((int)16640);
        this.renderGltfModels();
    }
}

