/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDDestination;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;

public class PDExplicitDestination
extends PDDestination {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_DISPLAY_MODE_XYZ = COSName.constant("XYZ");
    public static final COSName CN_DISPLAY_MODE_Fit = COSName.constant("Fit");
    public static final COSName CN_DISPLAY_MODE_FitH = COSName.constant("FitH");
    public static final COSName CN_DISPLAY_MODE_FitV = COSName.constant("FitV");
    public static final COSName CN_DISPLAY_MODE_FitR = COSName.constant("FitR");
    public static final COSName CN_DISPLAY_MODE_FitB = COSName.constant("FitB");
    public static final COSName CN_DISPLAY_MODE_FitBH = COSName.constant("FitBH");
    public static final COSName CN_DISPLAY_MODE_FitBV = COSName.constant("FitBV");

    protected PDExplicitDestination(COSObject cOSObject) {
        super(cOSObject);
    }

    public COSName getDisplayMode() {
        COSArray cOSArray = this.cosGetArray();
        if (cOSArray.size() < 2) {
            return null;
        }
        return cOSArray.get(1).asName();
    }

    public PDPage getPage(PDDocument pDDocument) {
        COSArray cOSArray = this.cosGetArray();
        COSObject cOSObject = cOSArray.get(0);
        if (cOSObject.asNumber() != null) {
            int n = cOSObject.asNumber().intValue();
            return pDDocument.getPageTree().getPageAt(n);
        }
        if (cOSObject.asDictionary() != null) {
            return (PDPage)PDPageNode.META.createFromCos(cOSObject.asDictionary());
        }
        return null;
    }

    public float[] getParameters() {
        COSArray cOSArray = this.cosGetArray();
        int n = cOSArray.size() - 2;
        if (n < 0) {
            return new float[0];
        }
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            COSNumber cOSNumber = cOSArray.get(n2 + 2).asNumber();
            fArray[n2] = cOSNumber == null ? 0.0f : cOSNumber.floatValue();
            ++n2;
        }
        return fArray;
    }

    @Override
    public PDExplicitDestination getResolvedDestination(PDDocument pDDocument) {
        return this;
    }

    public void setDisplayMode(COSName cOSName) {
        COSArray cOSArray = this.cosGetArray();
        if (cOSArray.size() == 0) {
            cOSArray.add(COSNull.NULL);
            cOSArray.add(cOSName);
        } else if (cOSArray.size() == 1) {
            cOSArray.add(cOSName);
        } else {
            cOSArray.set(1, cOSName);
        }
    }

    public void setPage(PDPage pDPage) {
        COSArray cOSArray = this.cosGetArray();
        if (cOSArray.size() == 0) {
            cOSArray.add(pDPage.cosGetObject());
        } else {
            cOSArray.set(0, pDPage.cosGetObject());
        }
    }

    public void setParameters(double[] dArray) {
        COSArray cOSArray = this.cosGetArray();
        while (cOSArray.size() < 2 + dArray.length) {
            cOSArray.add(COSNull.NULL);
        }
        int n = 0;
        while (n < dArray.length) {
            cOSArray.set(n + 2, COSFixed.create(dArray[n]));
            ++n;
        }
    }

    public void setParameters(float[] fArray) {
        COSArray cOSArray = this.cosGetArray();
        while (cOSArray.size() < 2 + fArray.length) {
            cOSArray.add(COSNull.NULL);
        }
        int n = 2;
        while (n < 2 + fArray.length) {
            cOSArray.set(n, COSFixed.create(fArray[n]));
            ++n;
        }
    }

    public static class MetaClass
    extends PDDestination.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDExplicitDestination(cOSObject);
        }
    }
}

