/*
 * Copyright (c) 2007, intarsys consulting GmbH
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of intarsys nor the names of its contributors may be used
 *   to endorse or promote products derived from this software without specific
 *   prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package de.intarsys.pdf.cos;

/**
 * A listener for changes in a {@link COSObject}.
 * 
 */
public interface ICOSObjectListener {
	/**
	 * A COSObject has changed its internal state. For any {@link COSObject}
	 * this may be a change in containment (slot == COSObject.SLOT_CONTAINER).
	 * <p>
	 * For containers itself, this may be a change in the collection of
	 * contained objects. For dictionaries, slot will be the {@link COSName} of
	 * the changed entry, for arrays slot will be the {@link Integer} key. A
	 * stream may indicate a change in its byte content using (slot ==
	 * COSStream.SLOT_BYTES).
	 * <p>
	 * A slot value of <code> null</code> may indicate a "changed all" event.
	 * For example you can expect for a <code>clear</code> operation on an
	 * array only a single "changed all" event.
	 * 
	 * @param object
	 *            The object that has changed
	 * @param slot
	 *            The slot in the object that has changed (or null for
	 *            unspecified change).
	 * @param oldValue
	 *            The old value of the slot if known.
	 * @param newValue
	 *            The new value of the slot if known.
	 */
	public void changed(COSObject object, Object slot, Object oldValue,
			Object newValue);
}
