/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.string;

import de.intarsys.tools.file.FileTools;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTools {
    public static final String CR = "\r";
    public static final String CRLF = "\r\n";
    public static final String DATEFORMAT_SIMPLE = "yy-MM-dd HH:mm:ss:SSSS";
    private static DateFormat DEFAULT_DATEFORMAT;
    public static final String EMPTY = "";
    public static final String FORMAT_D = "d";
    public static final String FORMAT_F = "f";
    public static final String FORMAT_I = "i";
    public static final String FORMAT_P = "p";
    public static final String FORMAT_S = "s";
    public static final String LF = "\n";
    private static final String[] NO_ARGS;
    public static final String SPACE = " ";

    static {
        NO_ARGS = new String[0];
    }

    public static String breakForced(String value, int max, String breakPattern) {
        StringBuilder sb = new StringBuilder();
        if (value != null) {
            int length;
            int begin = 0;
            int end = max;
            int currentlength = length = value.length();
            while (currentlength > max) {
                sb.append(value.substring(begin, end));
                begin += max;
                end += max;
                if ((currentlength -= max) <= 0) continue;
                sb.append(breakPattern);
            }
            if (end > length) {
                end = length;
            }
            sb.append(value.substring(begin, end));
        }
        return sb.toString();
    }

    public static String capitalize(String text) {
        if (StringTools.isEmpty(text)) {
            return EMPTY;
        }
        String first = text.substring(0, 1);
        first = first.toUpperCase();
        if (text.length() > 1) {
            return String.valueOf(first) + text.substring(1);
        }
        return first;
    }

    public static void clear(char[] value) {
        if (value == null) {
            return;
        }
        Arrays.fill(value, '0');
    }

    public static String format(Object value, String format) {
        if (value == null) {
            return EMPTY;
        }
        if (format.startsWith(FORMAT_S)) {
            return StringTools.formatString(value, format.substring(1));
        }
        if (format.startsWith(FORMAT_F)) {
            return StringTools.formatFloat(value, format.substring(1));
        }
        if (format.startsWith(FORMAT_I)) {
            return StringTools.formatInteger(value, format.substring(1));
        }
        if (format.startsWith(FORMAT_D)) {
            return StringTools.formatDate(value, format.substring(1));
        }
        if (format.startsWith(FORMAT_P)) {
            return StringTools.formatPath(value, format.substring(1));
        }
        if (value instanceof Date) {
            return new SimpleDateFormat(DATEFORMAT_SIMPLE).format(value);
        }
        if (value instanceof Long) {
            return Long.toString((Long)value, 32);
        }
        return value.toString();
    }

    protected static String formatDate(Object value, String format) {
        Date date = null;
        if (value instanceof Date) {
            date = (Date)value;
        } else if (value instanceof Number) {
            date = new Date(((Number)value).longValue());
        } else {
            if (value instanceof String) {
                return (String)value;
            }
            return EMPTY;
        }
        if (StringTools.isEmpty(format)) {
            return StringTools.formatDateDefault(date);
        }
        String pattern = StringTools.parseArgsString(format);
        if (pattern == null) {
            int dateTime = 43;
            int command = format.charAt(0);
            if (command == 100 || command == 116) {
                dateTime = command;
                command = format.length() > 1 ? (int)format.charAt(1) : 102;
            }
            if (dateTime == 100) {
                if (command == 115) {
                    DateFormat dateFormat = DateFormat.getDateInstance(3);
                    return dateFormat.format(date);
                }
                if (command == 109) {
                    DateFormat dateFormat = DateFormat.getDateInstance(2);
                    return dateFormat.format(date);
                }
                if (command == 102) {
                    DateFormat dateFormat = DateFormat.getDateInstance(0);
                    return dateFormat.format(date);
                }
            } else if (dateTime == 116) {
                if (command == 115) {
                    DateFormat dateFormat = DateFormat.getTimeInstance(3);
                    return dateFormat.format(date);
                }
                if (command == 109) {
                    DateFormat dateFormat = DateFormat.getTimeInstance(2);
                    return dateFormat.format(date);
                }
                if (command == 102) {
                    DateFormat dateFormat = DateFormat.getTimeInstance(0);
                    return dateFormat.format(date);
                }
            } else {
                if (command == 115) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                    return dateFormat.format(date);
                }
                if (command == 109) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
                    return dateFormat.format(date);
                }
                if (command == 102) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
                    return dateFormat.format(date);
                }
            }
            return StringTools.formatDateDefault(date);
        }
        SimpleDateFormat tempFormat = new SimpleDateFormat(pattern);
        try {
            return tempFormat.format(date);
        }
        catch (Exception e) {
            return StringTools.formatDateDefault(date);
        }
    }

    protected static synchronized String formatDateDefault(Date date) {
        if (DEFAULT_DATEFORMAT == null) {
            DEFAULT_DATEFORMAT = new SimpleDateFormat("yyyy_MM_dd-HH_mm_ss_SSS");
        }
        return DEFAULT_DATEFORMAT.format(date);
    }

    protected static String formatFloat(Object value, String format) {
        if (value == null) {
            return EMPTY;
        }
        double number = 0.0;
        if (value instanceof Number) {
            number = ((Number)value).doubleValue();
        } else if (value instanceof Date) {
            number = ((Date)value).getTime();
        } else if (value instanceof String) {
            try {
                number = Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return (String)value;
            }
        } else {
            return value.toString();
        }
        String pattern = StringTools.parseArgsString(format);
        NumberFormat tempFormat = null;
        tempFormat = pattern == null ? NumberFormat.getNumberInstance() : new DecimalFormat(pattern);
        try {
            return tempFormat.format(number);
        }
        catch (Exception e) {
            return value.toString();
        }
    }

    protected static String formatInteger(Object value, String format) {
        if (value == null) {
            return EMPTY;
        }
        int base = 100;
        if (format.length() > 1) {
            base = format.charAt(1);
        }
        long number = 0L;
        if (value instanceof Number) {
            number = ((Number)value).longValue();
        } else if (value instanceof Date) {
            number = ((Date)value).getTime();
        } else if (value instanceof String) {
            try {
                number = Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                return (String)value;
            }
        } else {
            return value.toString();
        }
        try {
            if (base == 98) {
                return Long.toString(number, 2);
            }
            if (base == 111) {
                return Long.toString(number, 8);
            }
            if (base == 100) {
                return Long.toString(number, 10);
            }
            if (base == 120) {
                return Long.toString(number, 16);
            }
            return Long.toString(number, 10);
        }
        catch (Exception e) {
            return value.toString();
        }
    }

    protected static String formatPath(Object value, String string) {
        return FileTools.trimPath(StringTools.safeString(value));
    }

    protected static String formatString(Object value, String format) {
        String result = null;
        result = value == null ? EMPTY : value.toString();
        String[] args = StringTools.parseArgs(format);
        if (args.length == 0) {
            return result;
        }
        int rangeStart = 0;
        int rangeStop = result.length() - 1;
        try {
            rangeStart = Integer.parseInt(args[0]);
            if (args.length == 2) {
                rangeStop = Integer.parseInt(args[1]);
            }
        }
        catch (NumberFormatException e) {
            return result;
        }
        if (rangeStart < 0) {
            rangeStart = result.length() + rangeStart;
        }
        if (rangeStop < 0) {
            rangeStop = result.length() + rangeStop;
        }
        if (rangeStart < 0) {
            rangeStart = 0;
        }
        if (rangeStop < 0) {
            rangeStop = 0;
        }
        if (rangeStart > rangeStop) {
            rangeStop = rangeStart - 1;
        }
        if (rangeStart > result.length()) {
            rangeStart = result.length();
        }
        if (rangeStop >= result.length()) {
            rangeStop = result.length() - 1;
        }
        return result.substring(rangeStart, rangeStop + 1);
    }

    public static String getCommonPrefix(String a, String b, boolean ignoreCase) {
        String tmpB;
        String tmpA;
        int lengthB;
        int lengthA = a.length();
        int max = lengthA > (lengthB = b.length()) ? lengthB : lengthA;
        int i = 0;
        if (ignoreCase) {
            tmpA = a.toLowerCase();
            tmpB = b.toLowerCase();
        } else {
            tmpA = a;
            tmpB = b;
        }
        while (i < max) {
            if (tmpA.charAt(i) != tmpB.charAt(i)) break;
            ++i;
        }
        return a.substring(0, i);
    }

    public static String getFirstLine(String text) {
        int indexLF;
        if (text == null) {
            return EMPTY;
        }
        int indexCR = text.indexOf(CR);
        if (indexCR == -1) {
            indexCR = text.length();
        }
        if ((indexLF = text.indexOf(LF)) == -1) {
            indexLF = text.length();
        }
        return text.substring(0, indexCR > indexLF ? indexLF : indexCR);
    }

    public static String getLeading(String value, int count) {
        if (value == null || value.length() <= count || count <= 3) {
            return value;
        }
        return String.valueOf(value.substring(0, count - 3)) + "...";
    }

    public static int getLineCount(String text) {
        int count = 1;
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\n') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String getTrailing(String value, int count) {
        if (value == null || value.length() <= count) {
            return value;
        }
        return "..." + value.substring(value.length() - count + 3, value.length());
    }

    public static boolean isEmpty(char[] value) {
        if (value == null || value.length == 0) {
            return true;
        }
        int i = 0;
        while (i < value.length) {
            if (!Character.isWhitespace(value[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0 || value.trim().length() == 0;
    }

    public static boolean isNumeric(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        char c = value.charAt(0);
        return Character.isDigit(c) || c == '-' || c == '+' || c == '.';
    }

    public static String join(List<String> elements, String separator) {
        return StringTools.join(elements.toArray(new String[0]), separator);
    }

    public static String join(String[] elements, String separator) {
        int last = elements.length - 1;
        if (last == -1) {
            return EMPTY;
        }
        if (last == 0) {
            return elements[0];
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < last) {
            buffer.append(elements[i]);
            if (separator != null) {
                buffer.append(separator);
            }
            ++i;
        }
        buffer.append(elements[last]);
        return buffer.toString();
    }

    public static String padLeft(String value, int count) {
        if (value == null || value.length() >= count) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        int i = count - value.length();
        while (i > 0) {
            sb.append(SPACE);
            --i;
        }
        sb.append(value);
        return sb.toString();
    }

    public static String padRight(String value, int count) {
        if (value == null || value.length() >= count) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        int i = count - value.length();
        while (i > 0) {
            sb.append(SPACE);
            --i;
        }
        return sb.toString();
    }

    protected static String[] parseArgs(String string) {
        String tempArgs = StringTools.parseArgsString(string);
        if (tempArgs == null) {
            return NO_ARGS;
        }
        return tempArgs.split(",");
    }

    protected static String parseArgsString(String string) {
        int open = string.indexOf(40);
        int close = string.indexOf(41);
        if (open == -1 || close == -1 || open > close) {
            return null;
        }
        return string.substring(open + 1, close);
    }

    public static String[] parseCommandline(String line) {
        return StringTools.parseCommandline(line, '\\');
    }

    public static String[] parseCommandline(String line, char escape) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        boolean quoted = false;
        boolean commented = false;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (commented) {
                if (c == '\n') {
                    commented = false;
                }
            } else if (escaped) {
                escaped = false;
                if (c != '\"') {
                    sb.append(escape);
                }
                sb.append(c);
            } else if (c == escape) {
                escaped = true;
            } else if (c == '\"') {
                quoted = !quoted;
            } else if (!quoted && c == '#') {
                if (sb.length() > 0) {
                    result.add(sb.toString());
                    sb.setLength(0);
                }
                commented = true;
            } else if (!quoted && Character.isWhitespace(c)) {
                if (sb.length() > 0) {
                    result.add(sb.toString());
                    sb.setLength(0);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (escaped) {
            sb.append(escape);
        }
        if (sb.length() > 0) {
            result.add(sb.toString());
            sb.setLength(0);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String safeString(Object object) {
        try {
            return String.valueOf(object);
        }
        catch (RuntimeException e) {
            return "<unprintable>";
        }
    }

    public static byte[] toByteArray(String value) {
        byte[] result = new byte[value.length()];
        value.getBytes(0, result.length, result, 0);
        return result;
    }

    public static String toString(byte[] value) {
        return new String(value, 0);
    }

    public static String trimAlphaNumeric(String value) {
        StringReader reader = new StringReader(value);
        char[] buffer = new char[1];
        StringWriter writer = new StringWriter();
        try {
            while (reader.read(buffer) != -1) {
                if (!Character.isLetterOrDigit(buffer[0])) continue;
                writer.write(buffer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static String trimLeft(String value) {
        int i = 0;
        int len = value.length();
        while (i < len) {
            if (!Character.isWhitespace(value.charAt(i))) break;
            ++i;
        }
        return value.substring(i);
    }

    public static String trimRight(String value) {
        int i = value.length() - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(value.charAt(i))) break;
            --i;
        }
        return value.substring(0, i + 1);
    }
}

