/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class TransientLocator
extends CommonLocator {
    private boolean alwaysUnchanged;
    private String canonicalName;
    private String localName;
    private String type;

    public TransientLocator(String name, String type) {
        if (name == null || type == null) {
            throw new NullPointerException("name and type may not be null for TransientLocator");
        }
        this.localName = name;
        this.canonicalName = this.canonical(name);
        this.type = this.canonical(type);
    }

    private String canonical(String name) {
        return name.trim().toLowerCase();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransientLocator) {
            TransientLocator other = (TransientLocator)obj;
            return other.canonicalName.equals(this.canonicalName) && other.type.equals(this.type);
        }
        return false;
    }

    public boolean exists() {
        return false;
    }

    public ILocator getChild(String name) {
        return null;
    }

    public String getFullName() {
        return String.valueOf(this.localName) + "." + this.type;
    }

    public InputStream getInputStream() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public String getLocalName() {
        return this.localName;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public ILocator getParent() {
        return null;
    }

    public IRandomAccess getRandomAccess() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public Reader getReader() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public Reader getReader(String encoding) throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public String getType() {
        return this.type;
    }

    public String getTypedName() {
        return String.valueOf(this.localName) + "." + this.type;
    }

    public Writer getWriter() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public Writer getWriter(String encoding) throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public int hashCode() {
        return this.canonicalName.hashCode();
    }

    public boolean isAlwaysUnchanged() {
        return this.alwaysUnchanged;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return new ILocator[0];
    }

    public void rename(String newName) throws IOException {
        this.localName = FileTools.getBaseName(newName);
        this.type = FileTools.getExtension(newName);
    }

    public void setAlwaysUnchanged(boolean paramAlwaysUnchanged) {
        this.alwaysUnchanged = paramAlwaysUnchanged;
    }

    public void setLocalName(String name) {
        this.localName = name;
        this.canonicalName = this.canonical(name);
    }

    public void synch() {
    }

    public URL toURL() {
        return null;
    }

    public void delete() throws IOException {
    }
}

