/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.ConstantFunctor;
import de.intarsys.tools.functor.DeclarationElement;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.DeclaredArgs;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgumentDeclaration;
import de.intarsys.tools.functor.IDeclaration;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;

public class ArgumentDeclaration
extends DeclarationElement
implements IArgumentDeclaration {
    private final IFunctor defaultFunctor;
    private final int index;

    public ArgumentDeclaration(Object declarationContext, String name, String modifiers, int index, IDeclaration[] nestedDeclarations) {
        super(declarationContext, name, modifiers, nestedDeclarations);
        this.defaultFunctor = new ConstantFunctor(nestedDeclarations);
        this.index = index;
    }

    public ArgumentDeclaration(Object declarationContext, String name, String modifiers, int index, IFunctor defaultFunctor) {
        super(declarationContext, name, modifiers);
        this.defaultFunctor = defaultFunctor;
        this.index = index;
    }

    public IFunctorCall accept(IFunctorCall call) throws DeclarationException {
        IArgs currentArgs = call.getArgs();
        DeclaredArgs declaredArgs = null;
        if (currentArgs instanceof DeclaredArgs) {
            declaredArgs = (DeclaredArgs)currentArgs;
        } else {
            declaredArgs = this.createDeclaredArgs(currentArgs);
            call.setArgs(declaredArgs);
        }
        declaredArgs.declare(call, this);
        return call;
    }

    protected DeclaredArgs createDeclaredArgs(IArgs currentArgs) {
        return DeclaredArgs.createTransparent(currentArgs);
    }

    public IFunctor getDefaultFunctor() {
        return this.defaultFunctor;
    }

    public int getIndex() {
        return this.index;
    }
}

