/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.exception;

import de.intarsys.tools.exception.KnownReason;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionTools {
    public static IOException createIOException(String message, Throwable cause) {
        IOException ioe = new IOException(message);
        ioe.initCause(cause);
        return ioe;
    }

    public static void fail() {
        throw new RuntimeException("failed");
    }

    public static <T> T futureSimpleGet(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof Error) {
                throw (Error)ex.getCause();
            }
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new InternalError("Program execution should not reach this point.");
        }
    }

    public static <T extends Number> T futureSimpleGetNumber(Future<T> future) {
        Number result = (Number)ExceptionTools.futureSimpleGet(future);
        if (result == null) {
            result = new Integer(-1);
        }
        return (T)result;
    }

    public static Throwable getInChain(Throwable t, Class<?> clazz) {
        if (clazz.isInstance(t)) {
            return t;
        }
        if (t.getCause() != null) {
            return ExceptionTools.getInChain(t.getCause(), clazz);
        }
        return null;
    }

    public static Throwable getRoot(Throwable t) {
        Throwable root = t;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    public static String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static boolean isInChain(Throwable t, Class<?> clazz) {
        if (clazz.isInstance(t)) {
            return true;
        }
        if (t.getCause() != null) {
            return ExceptionTools.isInChain(t.getCause(), clazz);
        }
        return false;
    }

    public static boolean isKnownReason(Throwable t) {
        if (t instanceof KnownReason) {
            return true;
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            return ExceptionTools.isKnownReason(cause);
        }
        return false;
    }
}

