/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import de.intarsys.tools.file.FileTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TempFileOutputStream
extends OutputStream {
    private File destination;
    private File tempFile;
    private FileOutputStream tempOutput;

    public TempFileOutputStream(File file) throws IOException {
        this(file, "tmp", "tmp");
    }

    public TempFileOutputStream(File file, String string, String string2) throws IOException {
        this.destination = file;
        this.tempFile = File.createTempFile(string, string2, file.getParentFile());
        this.tempOutput = new FileOutputStream(this.tempFile);
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.tempOutput.close();
            FileTools.copyBinaryFile(this.tempFile, this.destination);
        }
        finally {
            this.tempFile.delete();
        }
    }

    @Override
    public void flush() throws IOException {
        this.tempOutput.flush();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.tempOutput.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.tempOutput.write(byArray, n, n2);
    }

    @Override
    public void write(int n) throws IOException {
        this.tempOutput.write(n);
    }
}

