/*
 * Decompiled with CFR 0.152.
 */
package de.hanbei.httpserver.request;

import de.hanbei.httpserver.common.Content;
import de.hanbei.httpserver.common.HTTPVersion;
import de.hanbei.httpserver.common.Header;
import de.hanbei.httpserver.common.Method;
import de.hanbei.httpserver.request.QueryParameter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public final class Request {
    private Method method;
    private URI requestUri;
    private HTTPVersion version;
    private Header header = new Header();
    private Content content = new Content();

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(URI requestUri) {
        this.requestUri = requestUri;
    }

    public List<QueryParameter> getQueryParameter() {
        ArrayList<QueryParameter> queryParameters = new ArrayList<QueryParameter>();
        String queryString = this.requestUri.getQuery();
        if (queryString != null) {
            String[] parameters;
            for (String parameterString : parameters = queryString.split("&")) {
                String[] parameterSplit = parameterString.split("=");
                QueryParameter parameter = new QueryParameter(parameterSplit[0], parameterSplit[1]);
                queryParameters.add(parameter);
            }
        }
        return queryParameters;
    }

    public void setVersion(HTTPVersion httpVersion) {
        this.version = httpVersion;
    }

    public HTTPVersion getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.method);
        builder.append(" ");
        builder.append(this.requestUri);
        builder.append(" HTTP/");
        builder.append((Object)this.version);
        builder.append("\n");
        builder.append(this.header.toString());
        return builder.toString();
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Header getHeader() {
        return this.header;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public boolean isEmpty() {
        return this.method == null && this.version == null && this.requestUri == null;
    }

    public URI getHost() {
        return URI.create(this.header.getHeaderValues("Host").get(0));
    }
}

