/*
 * Decompiled with CFR 0.152.
 */
package de.hanbei.httpserver;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import de.hanbei.httpserver.Mapping;
import de.hanbei.httpserver.RequestProcessor;
import de.hanbei.httpserver.common.Header;
import de.hanbei.httpserver.common.Method;
import de.hanbei.httpserver.exceptions.ServerErrorException;
import de.hanbei.httpserver.request.Request;
import de.hanbei.httpserver.response.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;

class MockHttpHandler
implements HttpHandler {
    private Map<Method, Mapping<Response>> predefinedResponses;
    private Map<Method, Mapping<RequestProcessor>> requestProcessorMapping = new HashMap<Method, Mapping<RequestProcessor>>();
    private Response defaultResponse;
    private boolean timeout;

    public MockHttpHandler() {
        this.predefinedResponses = new HashMap<Method, Mapping<Response>>();
        this.defaultResponse = Response.notFound().build();
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        Method method = Method.valueOf(httpExchange.getRequestMethod());
        URI requestURI = httpExchange.getRequestURI();
        Response response = this.getResponse(requestURI, method);
        RequestProcessor processor = this.getProcessor(method, requestURI);
        if (processor != null) {
            try {
                Request request = this.portRequest(httpExchange);
                response = processor.process(request);
            }
            catch (Exception e) {
                throw new ServerErrorException("Error in porting requests", e);
            }
        }
        try {
            if (!this.timeout) {
                this.sendHeaders(httpExchange, response);
                this.sendContent(httpExchange, response);
            }
        }
        catch (Exception e) {
            throw new ServerErrorException("Error sending the response", e);
        }
        finally {
            httpExchange.close();
        }
    }

    private Request portRequest(HttpExchange httpExchange) throws IOException {
        String contentRange;
        Request request = new Request();
        Headers requestHeaders = httpExchange.getRequestHeaders();
        Header header = request.getHeader();
        for (String key : requestHeaders.keySet()) {
            Iterator iterator = requestHeaders.get(key).iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                header.addParameter(key, value);
            }
        }
        String encoding = requestHeaders.getFirst("Content-Encoding");
        if (encoding != null) {
            request.getContent().setEncoding(encoding);
        }
        request.getContent().setLanguage(requestHeaders.getFirst("Content-Language"));
        request.getContent().setMd5(requestHeaders.getFirst("Content-MD5"));
        String contentType = requestHeaders.getFirst("Content-Type");
        if (contentType != null) {
            if (encoding != null) {
                request.getContent().setMimetype(contentType + ";" + encoding);
            } else {
                request.getContent().setMimetype(contentType);
            }
        }
        if ((contentRange = requestHeaders.getFirst("Content-Range")) != null) {
            request.getContent().setRange(contentRange);
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)httpExchange.getRequestBody(), (OutputStream)bytes);
        request.getContent().setContent(bytes.toByteArray());
        return request;
    }

    private void sendContent(HttpExchange httpExchange, Response defaultResponse) throws IOException {
        httpExchange.getResponseBody().write(defaultResponse.getContent().getContent());
    }

    private void sendHeaders(HttpExchange httpExchange, Response response) throws IOException {
        int length = response.getContent().getLength();
        int statusCode = response.getStatus().getStatusCode();
        Headers responseHeaders = httpExchange.getResponseHeaders();
        Header headers = response.getHeader();
        for (String headerField : headers.getHeaderFields()) {
            for (Header.Parameter value : headers.getHeaderParameter(headerField)) {
                responseHeaders.add(headerField, value.toString());
            }
        }
        this.addHeaderIfSet(responseHeaders, "Content-Encoding", response.getContent().getEncoding());
        this.addHeaderIfSet(responseHeaders, "Content-Language", response.getContent().getLanguage());
        this.addHeaderIfSet(responseHeaders, "Content-MD5", response.getContent().getMd5());
        this.addHeaderIfSet(responseHeaders, "Content-Type", response.getContent().getComposedContentType());
        this.addHeaderIfSet(responseHeaders, "Content-Range", response.getContent().getRange());
        httpExchange.sendResponseHeaders(statusCode, Math.max(0, length));
    }

    private void addHeaderIfSet(Headers responseHeaders, String name, String value) {
        if (value != null) {
            responseHeaders.add(name, value);
        }
    }

    private Response getResponse(URI requestUri1, Method method) {
        String requestUri = this.trimSlashes(requestUri1);
        Mapping<Response> mapping = this.predefinedResponses.get((Object)method);
        if (mapping == null) {
            return this.defaultResponse;
        }
        Response response = mapping.get(requestUri);
        if (response == null) {
            return this.defaultResponse;
        }
        return response;
    }

    public Response getDefaultResponse() {
        return this.defaultResponse;
    }

    public void setDefaultResponse(Response defaultResponse) {
        this.defaultResponse = defaultResponse;
    }

    public void addResponse(Method method, URI uri, Response response) {
        Mapping<Response> mapping = this.predefinedResponses.get((Object)method);
        if (mapping == null) {
            mapping = new Mapping();
            this.predefinedResponses.put(method, mapping);
        }
        mapping.add(this.trimSlashes(uri), response);
    }

    private RequestProcessor getProcessor(Method method, URI requestUriP) {
        String requestUri = this.trimSlashes(requestUriP);
        Mapping<RequestProcessor> mapping = this.requestProcessorMapping.get((Object)method);
        RequestProcessor processor = null;
        if (mapping != null) {
            processor = mapping.get(requestUri);
        }
        return processor;
    }

    private String trimSlashes(URI uri) {
        String uriString = uri.toString();
        return uriString.replaceAll("^/|/$", "");
    }

    public void setTimeout(boolean shouldTimeout) {
        this.timeout = shouldTimeout;
    }

    public boolean isTimeoutSet() {
        return this.timeout;
    }

    public void addRequestProcessor(Method method, URI uri, RequestProcessor processor) {
        Mapping<RequestProcessor> mapping = this.requestProcessorMapping.get((Object)method);
        if (mapping == null) {
            mapping = new Mapping();
            this.requestProcessorMapping.put(method, mapping);
        }
        mapping.add(this.trimSlashes(uri), processor);
    }
}

