/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.event.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import de.greenrobot.event.EventBus;
import de.greenrobot.event.util.ErrorDialogFragmentFactory;
import de.greenrobot.event.util.HasExecutionScope;
import de.greenrobot.event.util.ThrowableFailureEvent;

public class ErrorDialogManager {
    public static ErrorDialogFragmentFactory<?> factory;
    protected static final String TAG_ERROR_DIALOG = "de.greenrobot.eventbus.error_dialog";
    protected static final String TAG_ERROR_DIALOG_MANAGER = "de.greenrobot.eventbus.error_dialog_manager";
    public static final String KEY_TITLE = "de.greenrobot.eventbus.errordialog.title";
    public static final String KEY_MESSAGE = "de.greenrobot.eventbus.errordialog.message";
    public static final String KEY_FINISH_AFTER_DIALOG = "de.greenrobot.eventbus.errordialog.finish_after_dialog";
    public static final String KEY_ICON_ID = "de.greenrobot.eventbus.errordialog.icon_id";
    public static final String KEY_EVENT_TYPE_ON_CLOSE = "de.greenrobot.eventbus.errordialog.event_type_on_close";

    public static void attachTo(Activity activity) {
        ErrorDialogManager.attachTo(activity, false, null);
    }

    public static void attachTo(Activity activity, boolean finishAfterDialog) {
        ErrorDialogManager.attachTo(activity, finishAfterDialog, null);
    }

    public static void attachTo(Activity activity, boolean finishAfterDialog, Bundle argumentsForErrorDialog) {
        Class<?> executionScope = activity.getClass();
        ErrorDialogManager.attachTo(activity, executionScope, finishAfterDialog, argumentsForErrorDialog);
    }

    public static void attachTo(Activity activity, Object executionScope, boolean finishAfterDialog, Bundle argumentsForErrorDialog) {
        if (factory == null) {
            throw new RuntimeException("You must set the static factory field to configure error dialogs for your app.");
        }
        if (ErrorDialogManager.isSupportActivity(activity)) {
            SupportManagerFragment.attachTo(activity, executionScope, finishAfterDialog, argumentsForErrorDialog);
        } else {
            HoneycombManagerFragment.attachTo(activity, executionScope, finishAfterDialog, argumentsForErrorDialog);
        }
    }

    private static boolean isSupportActivity(Activity activity) {
        boolean isSupport = false;
        Class<?> c = activity.getClass().getSuperclass();
        while (true) {
            if (c == null) {
                throw new RuntimeException("Illegal activity type: " + activity.getClass());
            }
            String name = c.getName();
            if (name.equals("android.support.v4.app.FragmentActivity")) {
                isSupport = true;
                break;
            }
            if (name.startsWith("com.actionbarsherlock.app") && (name.endsWith(".SherlockActivity") || name.endsWith(".SherlockListActivity") || name.endsWith(".SherlockPreferenceActivity"))) {
                throw new RuntimeException("Please use SherlockFragmentActivity. Illegal activity: " + name);
            }
            if (name.equals("android.app.Activity")) {
                if (Build.VERSION.SDK_INT >= 11) break;
                throw new RuntimeException("Illegal activity without fragment support. Either use Android 3.0+ or android.support.v4.app.FragmentActivity.");
            }
            c = c.getSuperclass();
        }
        return isSupport;
    }

    protected static void checkLogException(ThrowableFailureEvent event) {
        if (ErrorDialogManager.factory.config.logExceptions) {
            String tag = ErrorDialogManager.factory.config.tagForLoggingExceptions;
            if (tag == null) {
                tag = EventBus.TAG;
            }
            Log.i((String)tag, (String)"Error dialog manager received exception", (Throwable)event.throwable);
        }
    }

    private static boolean isInExecutionScope(Object executionScope, ThrowableFailureEvent event) {
        Object eventExecutionScope;
        return executionScope == null || !(event instanceof HasExecutionScope) || (eventExecutionScope = event.getExecutionScope()) == null || eventExecutionScope.equals(executionScope);
    }

    @TargetApi(value=11)
    public static class HoneycombManagerFragment
    extends Fragment {
        protected boolean finishAfterDialog;
        protected Bundle argumentsForErrorDialog;
        private EventBus eventBus;
        private Object executionScope;

        public void onResume() {
            super.onResume();
            this.eventBus = ErrorDialogManager.factory.config.getEventBus();
            this.eventBus.register((Object)this);
        }

        public void onPause() {
            this.eventBus.unregister((Object)this);
            super.onPause();
        }

        public void onEventMainThread(ThrowableFailureEvent event) {
            android.app.DialogFragment errorFragment;
            if (!ErrorDialogManager.isInExecutionScope(this.executionScope, event)) {
                return;
            }
            ErrorDialogManager.checkLogException(event);
            android.app.FragmentManager fm = this.getFragmentManager();
            fm.executePendingTransactions();
            android.app.DialogFragment existingFragment = (android.app.DialogFragment)fm.findFragmentByTag(ErrorDialogManager.TAG_ERROR_DIALOG);
            if (existingFragment != null) {
                existingFragment.dismiss();
            }
            if ((errorFragment = (android.app.DialogFragment)factory.prepareErrorFragment(event, this.finishAfterDialog, this.argumentsForErrorDialog)) != null) {
                errorFragment.show(fm, ErrorDialogManager.TAG_ERROR_DIALOG);
            }
        }

        public static void attachTo(Activity activity, Object executionScope, boolean finishAfterDialog, Bundle argumentsForErrorDialog) {
            android.app.FragmentManager fm = activity.getFragmentManager();
            HoneycombManagerFragment fragment = (HoneycombManagerFragment)fm.findFragmentByTag(ErrorDialogManager.TAG_ERROR_DIALOG_MANAGER);
            if (fragment == null) {
                fragment = new HoneycombManagerFragment();
                fm.beginTransaction().add((Fragment)fragment, ErrorDialogManager.TAG_ERROR_DIALOG_MANAGER).commit();
                fm.executePendingTransactions();
            }
            fragment.finishAfterDialog = finishAfterDialog;
            fragment.argumentsForErrorDialog = argumentsForErrorDialog;
            fragment.executionScope = executionScope;
        }
    }

    public static class SupportManagerFragment
    extends android.support.v4.app.Fragment {
        protected boolean finishAfterDialog;
        protected Bundle argumentsForErrorDialog;
        private EventBus eventBus;
        private boolean skipRegisterOnNextResume;
        private Object executionScope;

        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.eventBus = ErrorDialogManager.factory.config.getEventBus();
            this.eventBus.register((Object)this);
            this.skipRegisterOnNextResume = true;
        }

        public void onResume() {
            super.onResume();
            if (this.skipRegisterOnNextResume) {
                this.skipRegisterOnNextResume = false;
            } else {
                this.eventBus = ErrorDialogManager.factory.config.getEventBus();
                this.eventBus.register((Object)this);
            }
        }

        public void onPause() {
            this.eventBus.unregister((Object)this);
            super.onPause();
        }

        public void onEventMainThread(ThrowableFailureEvent event) {
            DialogFragment errorFragment;
            if (!ErrorDialogManager.isInExecutionScope(this.executionScope, event)) {
                return;
            }
            ErrorDialogManager.checkLogException(event);
            FragmentManager fm = this.getFragmentManager();
            fm.executePendingTransactions();
            DialogFragment existingFragment = (DialogFragment)fm.findFragmentByTag(ErrorDialogManager.TAG_ERROR_DIALOG);
            if (existingFragment != null) {
                existingFragment.dismiss();
            }
            if ((errorFragment = (DialogFragment)factory.prepareErrorFragment(event, this.finishAfterDialog, this.argumentsForErrorDialog)) != null) {
                errorFragment.show(fm, ErrorDialogManager.TAG_ERROR_DIALOG);
            }
        }

        public static void attachTo(Activity activity, Object executionScope, boolean finishAfterDialog, Bundle argumentsForErrorDialog) {
            FragmentManager fm = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportManagerFragment fragment = (SupportManagerFragment)fm.findFragmentByTag(ErrorDialogManager.TAG_ERROR_DIALOG_MANAGER);
            if (fragment == null) {
                fragment = new SupportManagerFragment();
                fm.beginTransaction().add((android.support.v4.app.Fragment)fragment, ErrorDialogManager.TAG_ERROR_DIALOG_MANAGER).commit();
                fm.executePendingTransactions();
            }
            fragment.finishAfterDialog = finishAfterDialog;
            fragment.argumentsForErrorDialog = argumentsForErrorDialog;
            fragment.executionScope = executionScope;
        }
    }
}

