/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.query;

import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.exception.MqttException;
import de.fraunhofer.iosb.ilt.frostclient.exception.ServiceFailureException;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.query.Expand;
import de.fraunhofer.iosb.ilt.frostclient.query.QueryParameter;
import de.fraunhofer.iosb.ilt.frostclient.query.QueryRequest;
import de.fraunhofer.iosb.ilt.frostclient.utils.MqttSubscription;
import de.fraunhofer.iosb.ilt.frostclient.utils.ParserUtils;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import de.fraunhofer.iosb.ilt.frostclient.utils.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query
implements QueryRequest<Query>,
QueryParameter<Query> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Query.class);
    private final SensorThingsService service;
    private final EntityType entityType;
    private final Entity parent;
    private final NavigationPropertyEntitySet navigationLink;
    private Boolean count;
    private String[] select;
    private String filter;
    private String orderby;
    private int skip = -1;
    private int top = -1;
    private String expandString;
    private Expand expand;

    public Query(SensorThingsService service, EntityType entityType) {
        this.service = service;
        this.entityType = entityType;
        this.parent = null;
        this.navigationLink = null;
    }

    public Query(SensorThingsService service, Entity parent, NavigationPropertyEntitySet navigationLink) {
        this.service = service;
        this.entityType = navigationLink.getEntityType();
        if (!parent.getEntityType().getNavigationSets().contains(navigationLink)) {
            throw new IllegalArgumentException("Entity " + String.valueOf(parent) + " has no navigationProperty " + String.valueOf(navigationLink));
        }
        this.navigationLink = navigationLink;
        this.parent = parent;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public SensorThingsService getService() {
        return this.service;
    }

    @Override
    public Query filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public Query top(int top) {
        this.top = top;
        return this;
    }

    @Override
    public Query orderBy(String orderby) {
        this.orderby = orderby;
        return this;
    }

    @Override
    public Query skip(int skip) {
        this.skip = skip;
        return this;
    }

    @Override
    public Query count(Boolean count) {
        this.count = count;
        return this;
    }

    public Query expand(String expansion) {
        this.expandString = expansion;
        return this;
    }

    @Override
    public Query expand(Expand expand) {
        this.expand = expand;
        if (expand != null) {
            expand.setOnType(this.entityType);
        }
        return this;
    }

    @Override
    public Query addExpandItem(Expand.ExpandItem item) {
        if (this.expand == null) {
            this.expand = new Expand().setOnType(this.entityType);
        }
        this.expand.addItem(item);
        return this;
    }

    private Expand.ExpandItem createExpandItem() {
        return new Expand.ExpandItem(null).count(this.count).top(this.top).skip(this.skip).select(this.select).filter(this.filter).orderBy(this.orderby).expand(this.expand);
    }

    @Override
    public Query select(String ... fields) {
        this.select = fields;
        return this;
    }

    public URI buildUrl() throws ServiceFailureException {
        try {
            URIBuilder uriBuilder = this.parent == null ? new URIBuilder(this.service.getFullPath(this.entityType).toURI()) : new URIBuilder(this.service.getFullPath(this.parent, this.navigationLink).toURI());
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (this.count != null) {
                params.add(new BasicNameValuePair("$count", "true"));
            }
            if (this.top >= 0) {
                params.add(new BasicNameValuePair("$top", Integer.toString(this.top)));
            }
            if (this.skip > 0) {
                params.add(new BasicNameValuePair("$skip", Integer.toString(this.skip)));
            }
            if (!StringHelper.isNullOrEmpty(this.select)) {
                params.add(new BasicNameValuePair("$select", String.join((CharSequence)",", this.select)));
            }
            if (!StringHelper.isNullOrEmpty(this.orderby)) {
                params.add(new BasicNameValuePair("$orderby", this.orderby));
            }
            if (!StringHelper.isNullOrEmpty(this.filter)) {
                params.add(new BasicNameValuePair("$filter", this.filter));
            }
            if (this.expand != null) {
                params.add(new BasicNameValuePair("$expand", this.expand.toUrl()));
            } else if (!StringHelper.isNullOrEmpty(this.expandString)) {
                params.add(new BasicNameValuePair("$expand", this.expandString));
            }
            uriBuilder.addParameters(params);
            return uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            throw new ServiceFailureException("Failed to fetch entities from query.", ex);
        }
    }

    @Override
    public Entity first() throws ServiceFailureException {
        this.top(1);
        List<Entity> asList = this.list().toList();
        if (asList.isEmpty()) {
            return null;
        }
        return asList.get(0);
    }

    @Override
    public EntitySet list() throws ServiceFailureException {
        EntitySet list;
        HttpGet httpGet = new HttpGet(this.buildUrl());
        LOGGER.debug("Fetching: {}", (Object)httpGet.getURI());
        httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        try (CloseableHttpResponse response = this.service.execute((HttpRequestBase)httpGet);){
            Utils.throwIfNotOk((HttpRequestBase)httpGet, response);
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            list = this.service.getJsonReader().parseEntitySet(this.entityType, json);
            list.setInitialLink(httpGet.getURI().toString());
        }
        catch (IOException ex) {
            throw new ServiceFailureException("Failed to fetch entities from query.", ex);
        }
        list.setService(this.service);
        list.setExpandItem(this.createExpandItem());
        return list;
    }

    @Override
    public Query subscribe(MqttSubscription sub) throws MqttException {
        EntityType tt;
        String mqttBasePath = this.service.getServerInfo().getMqttBasePath();
        StringBuilder topic = new StringBuilder(mqttBasePath);
        if (this.parent == null) {
            topic.append(this.entityType.mainSet);
            tt = this.entityType;
        } else {
            topic.append(ParserUtils.relationPath(this.parent, this.navigationLink));
            tt = this.navigationLink.getEntityType();
        }
        StringBuilder collectedParams = new StringBuilder();
        if (this.service.getServerInfo().isMqttExpandAllowed()) {
            if (this.expand != null) {
                this.addParamToTopic(collectedParams, "$expand", this.expand.toUrl());
            } else if (!StringHelper.isNullOrEmpty(this.expandString)) {
                this.addParamToTopic(collectedParams, "$expand", this.expandString);
            }
        }
        if (this.service.getServerInfo().isMqttFilterAllowed() && !StringHelper.isNullOrEmpty(this.filter)) {
            this.addParamToTopic(collectedParams, "$filter", this.filter);
        }
        if (!StringHelper.isNullOrEmpty(this.select)) {
            this.addParamToTopic(collectedParams, "$select", String.join((CharSequence)",", this.select));
        }
        topic.append((CharSequence)collectedParams);
        sub.setTopic(topic.toString()).setReturnType(tt);
        this.service.subscribe(sub);
        return this;
    }

    public void addParamToTopic(StringBuilder collectedParam, String name, String value) {
        if (collectedParam.isEmpty()) {
            collectedParam.append('?').append(name).append('=').append(value);
        } else {
            collectedParam.append('&').append(name).append('=').append(value);
        }
    }

    public void delete() throws ServiceFailureException {
        HttpDelete httpDelete;
        try {
            URIBuilder uriBuilder = this.parent != null ? new URIBuilder(this.service.getFullPath(this.parent, this.navigationLink).toURI()) : new URIBuilder(this.service.getFullPath(this.entityType).toURI());
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (!StringHelper.isNullOrEmpty(this.filter)) {
                params.add(new BasicNameValuePair("$filter", this.filter));
            }
            uriBuilder.addParameters(params);
            httpDelete = new HttpDelete(uriBuilder.build());
        }
        catch (URISyntaxException ex) {
            throw new ServiceFailureException("Failed to delete from query.", ex);
        }
        LOGGER.debug("Deleting: {}", (Object)httpDelete.getURI());
        httpDelete.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        try (CloseableHttpResponse response = this.service.execute((HttpRequestBase)httpDelete);){
            Utils.throwIfNotOk((HttpRequestBase)httpDelete, response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        catch (IOException ex) {
            throw new ServiceFailureException("Failed to delete from query.", ex);
        }
    }
}

