/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple;

import com.fasterxml.jackson.databind.JsonNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint.AllowedTimes;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple.AbstractRange;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.util.UnitOfMeasurement;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeRange
extends AbstractRange<TimeRange, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeRange.class);
    private String referenceTime;
    private String localFrame;
    private UnitOfMeasurement uom;
    private AllowedTimes constraint;
    private List<String> value;

    public String getReferenceTime() {
        return this.referenceTime;
    }

    public TimeRange setReferenceTime(String referenceTime) {
        this.referenceTime = referenceTime;
        return this;
    }

    public String getLocalFrame() {
        return this.localFrame;
    }

    public TimeRange setLocalFrame(String localFrame) {
        this.localFrame = localFrame;
        return this;
    }

    public UnitOfMeasurement getUom() {
        return this.uom;
    }

    public TimeRange setUom(UnitOfMeasurement uom) {
        this.uom = uom;
        return this;
    }

    public AllowedTimes getConstraint() {
        return this.constraint;
    }

    public TimeRange setConstraint(AllowedTimes constraint) {
        this.constraint = constraint;
        return this;
    }

    @Override
    public List<String> getValue() {
        return this.value;
    }

    @Override
    public TimeRange setValue(List<String> value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean valueIsValid() {
        return this.validate(this.value);
    }

    @Override
    protected boolean validateArray(JsonNode input) {
        if (this.constraint == null) {
            return true;
        }
        for (JsonNode item : input) {
            if (!item.isTextual()) {
                LOGGER.debug("Non-text value {} for TimeRange.", (Object)input);
                return false;
            }
            if (this.constraint.isValid(item.asText(), this.uom)) continue;
            LOGGER.error("Item '{}' does not fit the constraint", (Object)item);
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(List<String> input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        int size = input.size();
        if (size != 2) {
            LOGGER.debug("Range must have 2 items, found: {}", (Object)size);
            return false;
        }
        if (this.constraint == null) {
            return true;
        }
        for (String item : input) {
            if (this.constraint.isValid(item, this.uom)) continue;
            LOGGER.error("Item '{}' does not fit the constraint", (Object)item);
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.referenceTime);
        hash = 97 * hash + Objects.hashCode(this.localFrame);
        hash = 97 * hash + Objects.hashCode(this.uom);
        hash = 97 * hash + Objects.hashCode(this.constraint);
        hash = 97 * hash + Objects.hashCode(this.value);
        hash = 97 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeRange other = (TimeRange)obj;
        if (!Objects.equals(this.referenceTime, other.referenceTime)) {
            return false;
        }
        if (!Objects.equals(this.localFrame, other.localFrame)) {
            return false;
        }
        if (!Objects.equals(this.uom, other.uom)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected TimeRange self() {
        return this;
    }
}

