/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple.AbstractSimpleComponent;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SweBoolean
extends AbstractSimpleComponent<SweBoolean, Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SweBoolean.class.getName());
    public static final String SWE_NAME = "Boolean";
    private Boolean value;

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public SweBoolean setValue(Boolean value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean valueIsValid() {
        return true;
    }

    @Override
    public boolean validate(Object input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (input instanceof JsonNode) {
            JsonNode j = (JsonNode)input;
            return this.validate(j);
        }
        if (input instanceof Boolean) {
            Boolean b = (Boolean)input;
            return this.validate(b);
        }
        LOGGER.debug("Non-boolean value {} for Count.", input);
        return false;
    }

    @Override
    public boolean validate(JsonNode input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (!input.isBoolean()) {
            LOGGER.debug("Non-boolean value {} for Count.", (Object)input);
            return false;
        }
        return true;
    }

    public boolean validate(Boolean value) {
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.value);
        hash = 71 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SweBoolean other = (SweBoolean)obj;
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected SweBoolean self() {
        return this;
    }

    @Override
    public ObjectNode asJsonSchema() {
        ObjectNode schema = super.asJsonSchema().put("type", "boolean");
        return schema;
    }
}

