/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple;

import com.fasterxml.jackson.databind.JsonNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint.AllowedValues;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple.AbstractRange;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountRange
extends AbstractRange<CountRange, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CountRange.class);
    private List<Long> value;
    private AllowedValues constraint;

    @Override
    public List<Long> getValue() {
        return this.value;
    }

    @Override
    public CountRange setValue(List<Long> value) {
        if (value.size() != 2) {
            throw new IllegalArgumentException("CountRange must have a value with exactly 2 values.");
        }
        this.value = value;
        return this;
    }

    public AllowedValues getConstraint() {
        return this.constraint;
    }

    public CountRange setConstraint(AllowedValues constraint) {
        this.constraint = constraint;
        return this;
    }

    @Override
    public boolean valueIsValid() {
        return this.validate(this.value);
    }

    @Override
    protected boolean validateArray(JsonNode input) {
        if (this.constraint == null) {
            return true;
        }
        for (JsonNode item : input) {
            if (!item.isIntegralNumber()) {
                LOGGER.debug("Non-integral value {} for CountRange.", (Object)input);
                return false;
            }
            if (this.constraint.isValid(item.decimalValue())) continue;
            LOGGER.error("Item '{}' does not fit the constraint", (Object)item);
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(List<Long> input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        int size = input.size();
        if (size != 2) {
            LOGGER.debug("Range must have 2 items, found: {}", (Object)size);
            return false;
        }
        if (this.constraint == null) {
            return true;
        }
        for (Long item : input) {
            if (this.constraint.isValid(new BigDecimal(item))) continue;
            LOGGER.error("Item '{}' does not fit the constraint", (Object)item);
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.value);
        hash = 79 * hash + Objects.hashCode(this.constraint);
        hash = 79 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CountRange other = (CountRange)obj;
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected CountRange self() {
        return this;
    }
}

