/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models;

import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.PkValue;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.models.CommonProperties;
import de.fraunhofer.iosb.ilt.frostclient.models.DataModel;
import de.fraunhofer.iosb.ilt.frostclient.models.SensorThingsV11Sensing;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.MapValue;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.AbstractDataComponent;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple.Quantity;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.util.UnitOfMeasurement;
import java.time.ZonedDateTime;
import java.util.Map;
import org.geojson.GeoJsonObject;

public class SensorThingsV20Core
implements DataModel {
    public static final String MQTT_BASE_PATH = "v2.0/";
    public static final String NAME_EP_RESULTTYPE = "resultType";
    public static final String NAME_NP_PROXIMATEFOI = "ProximateFeatureOfInterest";
    public static final String NAME_NP_ULTIMATEFOI = "UltimateFeatureOfInterest";
    public static final EntityPropertyMain<Object> EP_FEATURE = SensorThingsV11Sensing.EP_FEATURE;
    public static final EntityPropertyMain<Object> EP_LOCATION = SensorThingsV11Sensing.EP_LOCATION;
    public static final EntityPropertyMain<Object> EP_METADATA = SensorThingsV11Sensing.EP_METADATA;
    public static final EntityPropertyMain<GeoJsonObject> EP_OBSERVEDAREA = SensorThingsV11Sensing.EP_OBSERVEDAREA;
    public static final EntityPropertyMain<TimeValue> EP_PHENOMENONTIME = SensorThingsV11Sensing.EP_PHENOMENONTIME;
    public static final EntityPropertyMain<TimeInterval> EP_PHENOMENONTIMEDS = SensorThingsV11Sensing.EP_PHENOMENONTIMEDS;
    public static final EntityPropertyMain<Object> EP_RESULT = SensorThingsV11Sensing.EP_RESULT;
    public static final EntityPropertyMain<TimeInstant> EP_RESULTTIME = SensorThingsV11Sensing.EP_RESULTTIME;
    public static final EntityPropertyMain<TimeInterval> EP_RESULTTIMEDS = SensorThingsV11Sensing.EP_RESULTTIMEDS;
    public static final EntityPropertyMain<AbstractDataComponent> EP_RESULTTYPE = new EntityPropertyMain("resultType", TypeComplex.STA_ABSTRACT_DATA_COMPONENT);
    public static final EntityPropertyMain<TimeInstant> EP_TIME = SensorThingsV11Sensing.EP_TIME;
    public static final EntityPropertyMain<TimeInterval> EP_VALIDTIME = SensorThingsV11Sensing.EP_VALIDTIME;
    public final NavigationPropertyEntity npObservationDatastream = new NavigationPropertyEntity("Datastream");
    public final NavigationPropertyEntity npObservationProximateFoi = new NavigationPropertyEntity("ProximateFeatureOfInterest");
    public final NavigationPropertyEntitySet npSensorDatastreams = new NavigationPropertyEntitySet("Datastreams");
    public final NavigationPropertyEntitySet npObspropDatastreams = new NavigationPropertyEntitySet("Datastreams");
    public final NavigationPropertyEntitySet npThingHistoricallocations = new NavigationPropertyEntitySet("HistoricalLocations");
    public final NavigationPropertyEntitySet npThingDatastreams = new NavigationPropertyEntitySet("Datastreams");
    public final NavigationPropertyEntitySet npThingLocations = new NavigationPropertyEntitySet("Locations");
    public final NavigationPropertyEntitySet npDatastreamObservations = new NavigationPropertyEntitySet("Observations", this.npObservationDatastream);
    public final NavigationPropertyEntitySet npDatastreamObservedproperties = new NavigationPropertyEntitySet("ObservedProperties", this.npObspropDatastreams);
    public final NavigationPropertyEntity npDatastreamSensor = new NavigationPropertyEntity("Sensor", this.npSensorDatastreams);
    public final NavigationPropertyEntity npDatastreamThing = new NavigationPropertyEntity("Thing", this.npThingDatastreams);
    public final NavigationPropertyEntity npDatastreamUltimateFoi = new NavigationPropertyEntity("UltimateFeatureOfInterest");
    public final NavigationPropertyEntity npDatastreamProximateFoi = new NavigationPropertyEntity("ProximateFeatureOfInterest");
    public final NavigationPropertyEntitySet npFeatureFeatureTypes = new NavigationPropertyEntitySet("FeatureTypes");
    public final NavigationPropertyEntitySet npFeatureObservations = new NavigationPropertyEntitySet("Observations", this.npObservationProximateFoi);
    public final NavigationPropertyEntitySet npFeatureDatastreamsProximate = new NavigationPropertyEntitySet("DatastreamsProximate", this.npDatastreamProximateFoi);
    public final NavigationPropertyEntitySet npFeatureDatastreamsUltimate = new NavigationPropertyEntitySet("DatastreamsUltimate", this.npDatastreamUltimateFoi);
    public final NavigationPropertyEntitySet npFeatureTypeFeatures = new NavigationPropertyEntitySet("Features", this.npFeatureFeatureTypes);
    public final NavigationPropertyEntitySet npLocationHistoricallocations = new NavigationPropertyEntitySet("HistoricalLocations");
    public final NavigationPropertyEntitySet npLocationThings = new NavigationPropertyEntitySet("Things", this.npThingLocations);
    public final NavigationPropertyEntitySet npHistlocLocations = new NavigationPropertyEntitySet("Locations", this.npLocationHistoricallocations);
    public final NavigationPropertyEntity npHistlocThing = new NavigationPropertyEntity("Thing", this.npThingHistoricallocations);
    public final EntityType etDatastream = new EntityType("Datastream", "Datastreams");
    public final EntityType etFeature = new EntityType("Feature", "Features");
    public final EntityType etFeatureType = new EntityType("FeatureType", "FeatureTypes");
    public final EntityType etHistoricalLocation = new EntityType("HistoricalLocation", "HistoricalLocations");
    public final EntityType etLocation = new EntityType("Location", "Locations");
    public final EntityType etObservedProperty = new EntityType("ObservedProperty", "ObservedProperties");
    public final EntityType etObservation = new EntityType("Observation", "Observations").setToStringMethod(e -> e.getEntityType().toString() + ": " + String.valueOf(e.getPrimaryKeyValues()) + " " + String.valueOf(e.getProperty(EP_PHENOMENONTIME)) + " " + String.valueOf(e.getProperty(EP_RESULT)));
    public final EntityType etSensor = new EntityType("Sensor", "Sensors");
    public final EntityType etThing = new EntityType("Thing", "Things");
    private ModelRegistry mr;

    @Override
    public final void init(SensorThingsService service, ModelRegistry modelRegistry) {
        if (this.mr != null) {
            throw new IllegalArgumentException("Already initialised.");
        }
        this.mr = modelRegistry;
        this.mr.addDataModel(this);
        this.mr.registerPropertyType(TypeComplex.STA_OBJECT).registerPropertyType(TypeComplex.STA_MAP).registerPropertyType(TypeComplex.STA_TIMEINTERVAL).registerPropertyType(TypeComplex.STA_TIMEVALUE).registerEntityType(this.etThing).registerEntityType(this.etSensor).registerEntityType(this.etLocation).registerEntityType(this.etDatastream).registerEntityType(this.etObservation).registerEntityType(this.etObservedProperty).registerEntityType(this.etFeature).registerEntityType(this.etFeatureType).registerEntityType(this.etHistoricalLocation);
        this.etDatastream.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(EP_RESULTTYPE).registerProperty(EP_OBSERVEDAREA).registerProperty(EP_PHENOMENONTIMEDS).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(EP_RESULTTIMEDS).registerProperty(this.npDatastreamSensor).registerProperty(this.npDatastreamThing).registerProperty(this.npDatastreamProximateFoi).registerProperty(this.npDatastreamUltimateFoi).registerProperty(this.npDatastreamObservedproperties).registerProperty(this.npDatastreamObservations);
        this.etFeature.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(CommonProperties.EP_ENCODINGTYPE).registerProperty(EP_FEATURE).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npFeatureFeatureTypes).registerProperty(this.npFeatureDatastreamsProximate).registerProperty(this.npFeatureDatastreamsUltimate).registerProperty(this.npFeatureObservations);
        this.etFeatureType.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DEFINITION).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npFeatureTypeFeatures);
        this.etHistoricalLocation.registerProperty(CommonProperties.EP_ID).registerProperty(EP_TIME).registerProperty(this.npHistlocThing).registerProperty(this.npHistlocLocations);
        this.etLocation.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(CommonProperties.EP_ENCODINGTYPE).registerProperty(EP_LOCATION).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npLocationHistoricallocations).registerProperty(this.npLocationThings);
        this.etObservation.registerProperty(CommonProperties.EP_ID).registerProperty(EP_PHENOMENONTIME).registerProperty(EP_RESULTTIME).registerProperty(EP_RESULT).registerProperty(EP_VALIDTIME).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npObservationDatastream).registerProperty(this.npObservationProximateFoi);
        this.etObservedProperty.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DEFINITION).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npObspropDatastreams);
        this.etSensor.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(CommonProperties.EP_ENCODINGTYPE).registerProperty(EP_METADATA).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npSensorDatastreams);
        this.etThing.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npThingLocations).registerProperty(this.npThingHistoricallocations).registerProperty(this.npThingDatastreams);
    }

    @Override
    public boolean isInitialised() {
        return this.mr != null;
    }

    @Override
    public String getMqttBasePath() {
        return MQTT_BASE_PATH;
    }

    public Entity newThing() {
        return new Entity(this.etThing);
    }

    public Entity newThing(Object id) {
        return new Entity(this.etThing).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newThing(String name, String description) {
        return ((Entity)this.newThing().setProperty((Property)CommonProperties.EP_NAME, (Object)name)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)description);
    }

    public Entity newThing(String name, String description, Map<String, Object> properties) {
        return this.newThing(name, description, new MapValue(properties));
    }

    public Entity newThing(String name, String description, MapValue properties) {
        return this.newThing(name, description).setProperty((Property)CommonProperties.EP_PROPERTIES, (Object)properties);
    }

    public Entity newLocation() {
        return new Entity(this.etLocation);
    }

    public Entity newLocation(Object id) {
        return new Entity(this.etLocation).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newLocation(String name, String description, GeoJsonObject location) {
        return this.newLocation(name, description, "application/geo+json", location);
    }

    public Entity newLocation(String name, String description, String encodingType, Object location) {
        return ((Entity)((Entity)((Entity)this.newLocation().setProperty((Property)CommonProperties.EP_NAME, (Object)name)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)description)).setProperty((Property)CommonProperties.EP_ENCODINGTYPE, (Object)encodingType)).setProperty((Property)EP_LOCATION, location);
    }

    public Entity newDatastream() {
        return new Entity(this.etDatastream);
    }

    public Entity newDatastream(Object id) {
        return new Entity(this.etDatastream).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newDatastream(String name, String description, String definition, UnitOfMeasurement uom) {
        return this.newDatastream(name, description, ((Quantity)new Quantity().setDefinition(definition)).setUom(uom));
    }

    public Entity newDatastream(String name, String description, AbstractDataComponent resultType) {
        return ((Entity)((Entity)this.newDatastream().setProperty((Property)CommonProperties.EP_NAME, (Object)name)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)description)).setProperty((Property)EP_RESULTTYPE, (Object)resultType);
    }

    public Entity newSensor() {
        return new Entity(this.etSensor);
    }

    public Entity newSensor(Object id) {
        return new Entity(this.etSensor).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newSensor(String name, String description, String encodingType, String metaData) {
        return ((Entity)((Entity)((Entity)this.newSensor().setProperty((Property)CommonProperties.EP_NAME, (Object)name)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)description)).setProperty((Property)CommonProperties.EP_ENCODINGTYPE, (Object)encodingType)).setProperty((Property)EP_METADATA, (Object)metaData);
    }

    public Entity newObservedProperty() {
        return new Entity(this.etObservedProperty);
    }

    public Entity newObservedProperty(Object id) {
        return new Entity(this.etObservedProperty).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newObservedProperty(String name, String definition, String desription) {
        return ((Entity)((Entity)this.newObservedProperty().setProperty((Property)CommonProperties.EP_NAME, (Object)name)).setProperty((Property)CommonProperties.EP_DEFINITION, (Object)definition)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)desription);
    }

    public Entity newObservation() {
        return new Entity(this.etObservation);
    }

    public Entity newObservation(Object result) {
        return this.newObservation().setProperty((Property)EP_RESULT, result);
    }

    public Entity newObservation(Object result, Entity datastream) {
        if (!this.etDatastream.equals(datastream.getEntityType())) {
            throw new IllegalArgumentException("Datastream Entity must have entityType Datastream, not " + String.valueOf(datastream.getEntityType()));
        }
        return ((Entity)this.newObservation().setProperty((Property)EP_RESULT, result)).setProperty((Property)this.npObservationDatastream, (Object)datastream);
    }

    public Entity newObservation(Object result, TimeValue phenomenonTime) {
        return this.newObservation(result).setProperty((Property)EP_PHENOMENONTIME, (Object)phenomenonTime);
    }

    public Entity newObservation(Object result, ZonedDateTime phenomenonTime) {
        return this.newObservation(result, TimeValue.create(phenomenonTime));
    }

    public Entity newObservation(Object result, TimeValue phenomenonTime, Entity datastream) {
        return this.newObservation(result, datastream).setProperty((Property)EP_PHENOMENONTIME, (Object)phenomenonTime);
    }

    public Entity newObservation(Object result, ZonedDateTime phenomenonTime, Entity datastream) {
        return this.newObservation(result, TimeValue.create(phenomenonTime), datastream);
    }

    public Entity newObservation(Object result, TimeInterval phenomenonTime) {
        return this.newObservation(result, new TimeValue(phenomenonTime));
    }

    public Entity newObservation(Object result, TimeInterval phenomenonTime, Entity datastream) {
        return this.newObservation(result, new TimeValue(phenomenonTime), datastream);
    }

    public Entity newHistoricalLocation() {
        return new Entity(this.etHistoricalLocation);
    }

    public Entity newHistoricalLocation(Object id) {
        return new Entity(this.etHistoricalLocation).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newHistoricalLocation(ZonedDateTime time) {
        return this.newHistoricalLocation().setProperty((Property)EP_TIME, (Object)TimeInstant.create(time));
    }

    public Entity newHistoricalLocation(ZonedDateTime time, Entity thing, Entity ... location) {
        return ((Entity)((Entity)this.newHistoricalLocation().setProperty((Property)EP_TIME, (Object)TimeInstant.create(time))).setProperty((Property)this.npHistlocThing, (Object)thing)).addNavigationEntity(this.npHistlocLocations, location);
    }

    public Entity newFeature() {
        return new Entity(this.etFeature);
    }

    public Entity newFeature(Object id) {
        return new Entity(this.etFeature).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newFeature(String name, String description, GeoJsonObject location) {
        return this.newFeature(name, description, "application/geo+json", location);
    }

    public Entity newFeature(String name, String description, String encodingType, Object location) {
        return ((Entity)((Entity)((Entity)this.newFeature().setProperty((Property)CommonProperties.EP_NAME, (Object)name)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)description)).setProperty((Property)CommonProperties.EP_ENCODINGTYPE, (Object)encodingType)).setProperty((Property)EP_FEATURE, location);
    }
}

