/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models;

import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.PkValue;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypePrimitive;
import de.fraunhofer.iosb.ilt.frostclient.models.CommonProperties;
import de.fraunhofer.iosb.ilt.frostclient.models.DataModel;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.MapValue;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.frostclient.utils.ParserUtils;
import de.fraunhofer.iosb.ilt.frostclient.utils.TypeReferencesHelper;
import java.time.ZonedDateTime;
import java.util.Map;
import org.geojson.GeoJsonObject;

public class SensorThingsV11Sensing
implements DataModel {
    public static final String MQTT_BASE_PATH = "v1.1/";
    public static final String NAME_DEFINITION = "definition";
    public static final String NAME_NAME = "name";
    public static final String NAME_SYMBOL = "symbol";
    public static final String NAME_EP_FEATURE = "feature";
    public static final String NAME_EP_LOCATION = "location";
    public static final String NAME_EP_METADATA = "metadata";
    public static final String NAME_EP_OBSERVATIONTYPE = "observationType";
    public static final String NAME_EP_OBSERVEDAREA = "observedArea";
    public static final String NAME_EP_PARAMETERS = "parameters";
    public static final String NAME_EP_PHENOMENONTIME = "phenomenonTime";
    public static final String NAME_EP_RESULT = "result";
    public static final String NAME_EP_RESULTTIME = "resultTime";
    public static final String NAME_EP_RESULTQUALITY = "resultQuality";
    public static final String NAME_EP_SYMBOL = "symbol";
    public static final String NAME_EP_TIME = "time";
    public static final String NAME_EP_UNITOFMEASUREMENT = "unitOfMeasurement";
    public static final String NAME_EP_VALIDTIME = "validTime";
    public static final EntityPropertyMain<Object> EP_FEATURE = new EntityPropertyMain("feature", TypePrimitive.EDM_GEOMETRY);
    public static final EntityPropertyMain<Object> EP_LOCATION = new EntityPropertyMain("location", TypePrimitive.EDM_GEOMETRY);
    public static final EntityPropertyMain<Object> EP_METADATA = new EntityPropertyMain("metadata", TypePrimitive.EDM_UNTYPED);
    public static final EntityPropertyMain<String> EP_OBSERVATIONTYPE = new EntityPropertyMain("observationType", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<GeoJsonObject> EP_OBSERVEDAREA = new EntityPropertyMain("observedArea", TypePrimitive.EDM_GEOMETRY).setReadOnly(true);
    public static final EntityPropertyMain<TimeValue> EP_PHENOMENONTIME = new EntityPropertyMain("phenomenonTime", TypeComplex.STA_TIMEVALUE);
    public static final EntityPropertyMain<TimeInterval> EP_PHENOMENONTIMEDS = new EntityPropertyMain("phenomenonTime", TypeComplex.STA_TIMEINTERVAL).setReadOnly(true);
    public static final EntityPropertyMain<MapValue> EP_PARAMETERS = new EntityPropertyMain("parameters", TypeComplex.STA_MAP);
    public static final EntityPropertyMain<Object> EP_RESULT = new EntityPropertyMain("result", TypePrimitive.EDM_UNTYPED, true);
    public static final EntityPropertyMain<TimeInstant> EP_RESULTTIME = new EntityPropertyMain("resultTime", TypePrimitive.EDM_DATETIMEOFFSET);
    public static final EntityPropertyMain<TimeInterval> EP_RESULTTIMEDS = new EntityPropertyMain("resultTime", TypeComplex.STA_TIMEINTERVAL).setReadOnly(true);
    public static final EntityPropertyMain<Object> EP_RESULTQUALITY = new EntityPropertyMain("resultQuality", TypeComplex.STA_OBJECT);
    public static final EntityPropertyMain<String> EP_SYMBOL = new EntityPropertyMain("symbol", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<TimeInstant> EP_TIME = new EntityPropertyMain("time", TypePrimitive.EDM_DATETIMEOFFSET);
    public static final EntityPropertyMain<TimeInterval> EP_VALIDTIME = new EntityPropertyMain("validTime", TypeComplex.STA_TIMEINTERVAL);
    public static final TypeComplex ept_Uom = new TypeComplex("UnitOfMeasurement", "The Unit Of Measurement Type", false, UnitOfMeasurement::new, ParserUtils.getDefaultDeserializer(TypeReferencesHelper.TYPE_REFERENCE_UOM), ParserUtils.getDefaultSerializer()).registerProperty(CommonProperties.EP_NAME).registerProperty(EP_SYMBOL).registerProperty(CommonProperties.EP_DEFINITION);
    public static final EntityPropertyMain<UnitOfMeasurement> EP_UNITOFMEASUREMENT = new EntityPropertyMain("unitOfMeasurement", ept_Uom);
    public final NavigationPropertyEntity npObservationDatastream = new NavigationPropertyEntity("Datastream");
    public final NavigationPropertyEntity npObservationFeatureofinterest = new NavigationPropertyEntity("FeatureOfInterest");
    public final NavigationPropertyEntitySet npSensorDatastreams = new NavigationPropertyEntitySet("Datastreams");
    public final NavigationPropertyEntitySet npObspropDatastreams = new NavigationPropertyEntitySet("Datastreams");
    public final NavigationPropertyEntitySet npThingHistoricallocations = new NavigationPropertyEntitySet("HistoricalLocations");
    public final NavigationPropertyEntitySet npThingDatastreams = new NavigationPropertyEntitySet("Datastreams");
    public final NavigationPropertyEntitySet npThingLocations = new NavigationPropertyEntitySet("Locations");
    public final NavigationPropertyEntitySet npDatastreamObservations = new NavigationPropertyEntitySet("Observations", this.npObservationDatastream);
    public final NavigationPropertyEntity npDatastreamObservedproperty = new NavigationPropertyEntity("ObservedProperty", this.npObspropDatastreams);
    public final NavigationPropertyEntity npDatastreamSensor = new NavigationPropertyEntity("Sensor", this.npSensorDatastreams);
    public final NavigationPropertyEntity npDatastreamThing = new NavigationPropertyEntity("Thing", this.npThingDatastreams);
    public final NavigationPropertyEntitySet npFeatureObservations = new NavigationPropertyEntitySet("Observations", this.npObservationFeatureofinterest);
    public final NavigationPropertyEntitySet npLocationHistoricallocations = new NavigationPropertyEntitySet("HistoricalLocations");
    public final NavigationPropertyEntitySet npLocationThings = new NavigationPropertyEntitySet("Things", this.npThingLocations);
    public final NavigationPropertyEntitySet npHistlocLocations = new NavigationPropertyEntitySet("Locations", this.npLocationHistoricallocations);
    public final NavigationPropertyEntity npHistlocThing = new NavigationPropertyEntity("Thing", this.npThingHistoricallocations);
    public final EntityType etThing = new EntityType("Thing", "Things");
    public final EntityType etSensor = new EntityType("Sensor", "Sensors");
    public final EntityType etObservedProperty = new EntityType("ObservedProperty", "ObservedProperties");
    public final EntityType etObservation = new EntityType("Observation", "Observations").setToStringMethod(e -> String.valueOf(e.getProperty(EP_PHENOMENONTIME)) + " " + String.valueOf(e.getProperty(EP_RESULT)));
    public final EntityType etLocation = new EntityType("Location", "Locations");
    public final EntityType etHistoricalLocation = new EntityType("HistoricalLocation", "HistoricalLocations");
    public final EntityType etFeatureOfInterest = new EntityType("FeatureOfInterest", "FeaturesOfInterest");
    public final EntityType etDatastream = new EntityType("Datastream", "Datastreams");
    private ModelRegistry mr;

    @Override
    public final void init(SensorThingsService service, ModelRegistry modelRegistry) {
        if (this.mr != null) {
            throw new IllegalArgumentException("Already initialised.");
        }
        this.mr = modelRegistry;
        this.mr.addDataModel(this);
        this.mr.registerPropertyType(ept_Uom).registerPropertyType(TypeComplex.STA_OBJECT).registerPropertyType(TypeComplex.STA_MAP).registerPropertyType(TypeComplex.STA_TIMEINTERVAL).registerPropertyType(TypeComplex.STA_TIMEVALUE).registerEntityType(this.etThing).registerEntityType(this.etSensor).registerEntityType(this.etLocation).registerEntityType(this.etDatastream).registerEntityType(this.etObservation).registerEntityType(this.etObservedProperty).registerEntityType(this.etFeatureOfInterest).registerEntityType(this.etHistoricalLocation);
        this.etDatastream.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(EP_OBSERVATIONTYPE).registerProperty(EP_UNITOFMEASUREMENT).registerProperty(EP_OBSERVEDAREA).registerProperty(EP_PHENOMENONTIMEDS).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(EP_RESULTTIMEDS).registerProperty(this.npDatastreamObservedproperty).registerProperty(this.npDatastreamSensor).registerProperty(this.npDatastreamThing).registerProperty(this.npDatastreamObservations);
        this.etFeatureOfInterest.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(CommonProperties.EP_ENCODINGTYPE).registerProperty(EP_FEATURE).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npFeatureObservations);
        this.etHistoricalLocation.registerProperty(CommonProperties.EP_ID).registerProperty(EP_TIME).registerProperty(this.npHistlocThing).registerProperty(this.npHistlocLocations);
        this.etLocation.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(CommonProperties.EP_ENCODINGTYPE).registerProperty(EP_LOCATION).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npLocationHistoricallocations).registerProperty(this.npLocationThings);
        this.etObservation.registerProperty(CommonProperties.EP_ID).registerProperty(EP_PHENOMENONTIME).registerProperty(EP_RESULTTIME).registerProperty(EP_RESULT).registerProperty(EP_RESULTQUALITY).registerProperty(EP_VALIDTIME).registerProperty(EP_PARAMETERS).registerProperty(this.npObservationDatastream).registerProperty(this.npObservationFeatureofinterest);
        this.etObservedProperty.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DEFINITION).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npObspropDatastreams);
        this.etSensor.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(CommonProperties.EP_ENCODINGTYPE).registerProperty(EP_METADATA).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npSensorDatastreams);
        this.etThing.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npThingLocations).registerProperty(this.npThingHistoricallocations).registerProperty(this.npThingDatastreams);
    }

    @Override
    public boolean isInitialised() {
        return this.mr != null;
    }

    @Override
    public String getMqttBasePath() {
        return MQTT_BASE_PATH;
    }

    public Entity newThing() {
        return new Entity(this.etThing);
    }

    public Entity newThing(Object id) {
        return new Entity(this.etThing).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newThing(String name, String description) {
        return ((Entity)this.newThing().setProperty((Property)CommonProperties.EP_NAME, (Object)name)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)description);
    }

    public Entity newThing(String name, String description, Map<String, Object> properties) {
        return this.newThing(name, description, new MapValue(properties));
    }

    public Entity newThing(String name, String description, MapValue properties) {
        return this.newThing(name, description).setProperty((Property)CommonProperties.EP_PROPERTIES, (Object)properties);
    }

    public Entity newLocation() {
        return new Entity(this.etLocation);
    }

    public Entity newLocation(Object id) {
        return new Entity(this.etLocation).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newLocation(String name, String description, GeoJsonObject location) {
        return this.newLocation(name, description, "application/geo+json", location);
    }

    public Entity newLocation(String name, String description, String encodingType, Object location) {
        return ((Entity)((Entity)((Entity)this.newLocation().setProperty((Property)CommonProperties.EP_NAME, (Object)name)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)description)).setProperty((Property)CommonProperties.EP_ENCODINGTYPE, (Object)encodingType)).setProperty((Property)EP_LOCATION, location);
    }

    public Entity newDatastream() {
        return new Entity(this.etDatastream);
    }

    public Entity newDatastream(Object id) {
        return new Entity(this.etDatastream).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newDatastream(String name, String description, UnitOfMeasurement uom) {
        return this.newDatastream(name, description, "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement", uom);
    }

    public Entity newDatastream(String name, String description, String observationType, UnitOfMeasurement uom) {
        return ((Entity)((Entity)((Entity)this.newDatastream().setProperty((Property)CommonProperties.EP_NAME, (Object)name)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)description)).setProperty((Property)EP_OBSERVATIONTYPE, (Object)observationType)).setProperty((Property)EP_UNITOFMEASUREMENT, (Object)uom);
    }

    public Entity newSensor() {
        return new Entity(this.etSensor);
    }

    public Entity newSensor(Object id) {
        return new Entity(this.etSensor).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newSensor(String name, String description, String encodingType, String metaData) {
        return ((Entity)((Entity)((Entity)this.newSensor().setProperty((Property)CommonProperties.EP_NAME, (Object)name)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)description)).setProperty((Property)CommonProperties.EP_ENCODINGTYPE, (Object)encodingType)).setProperty((Property)EP_METADATA, (Object)metaData);
    }

    public Entity newObservedProperty() {
        return new Entity(this.etObservedProperty);
    }

    public Entity newObservedProperty(Object id) {
        return new Entity(this.etObservedProperty).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newObservedProperty(String name, String definition, String desription) {
        return ((Entity)((Entity)this.newObservedProperty().setProperty((Property)CommonProperties.EP_NAME, (Object)name)).setProperty((Property)CommonProperties.EP_DEFINITION, (Object)definition)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)desription);
    }

    public Entity newObservation() {
        return new Entity(this.etObservation);
    }

    public Entity newObservation(Object result) {
        return this.newObservation().setProperty((Property)EP_RESULT, result);
    }

    public Entity newObservation(Object result, Entity datastream) {
        if (!this.etDatastream.equals(datastream.getEntityType())) {
            throw new IllegalArgumentException("Datastream Entity must have entityType Datastream, not " + String.valueOf(datastream.getEntityType()));
        }
        return ((Entity)this.newObservation().setProperty((Property)EP_RESULT, result)).setProperty((Property)this.npObservationDatastream, (Object)datastream);
    }

    public Entity newObservation(Object result, TimeValue phenomenonTime) {
        return this.newObservation(result).setProperty((Property)EP_PHENOMENONTIME, (Object)phenomenonTime);
    }

    public Entity newObservation(Object result, ZonedDateTime phenomenonTime) {
        return this.newObservation(result, TimeValue.create(phenomenonTime));
    }

    public Entity newObservation(Object result, TimeValue phenomenonTime, Entity datastream) {
        return this.newObservation(result, datastream).setProperty((Property)EP_PHENOMENONTIME, (Object)phenomenonTime);
    }

    public Entity newObservation(Object result, ZonedDateTime phenomenonTime, Entity datastream) {
        return this.newObservation(result, TimeValue.create(phenomenonTime), datastream);
    }

    public Entity newObservation(Object result, TimeInterval phenomenonTime) {
        return this.newObservation(result, new TimeValue(phenomenonTime));
    }

    public Entity newObservation(Object result, TimeInterval phenomenonTime, Entity datastream) {
        return this.newObservation(result, new TimeValue(phenomenonTime), datastream);
    }

    public Entity newHistoricalLocation() {
        return new Entity(this.etHistoricalLocation);
    }

    public Entity newHistoricalLocation(Object id) {
        return new Entity(this.etHistoricalLocation).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newHistoricalLocation(ZonedDateTime time) {
        return this.newHistoricalLocation().setProperty((Property)EP_TIME, (Object)TimeInstant.create(time));
    }

    public Entity newHistoricalLocation(ZonedDateTime time, Entity thing, Entity ... location) {
        return ((Entity)((Entity)this.newHistoricalLocation().setProperty((Property)EP_TIME, (Object)TimeInstant.create(time))).setProperty((Property)this.npHistlocThing, (Object)thing)).addNavigationEntity(this.npHistlocLocations, location);
    }

    public Entity newFeatureOfInterest() {
        return new Entity(this.etFeatureOfInterest);
    }

    public Entity newFeatureOfInterest(Object id) {
        return new Entity(this.etFeatureOfInterest).setPrimaryKeyValues(PkValue.of(id));
    }

    public Entity newFeatureOfInterest(String name, String description, GeoJsonObject location) {
        return this.newFeatureOfInterest(name, description, "application/geo+json", location);
    }

    public Entity newFeatureOfInterest(String name, String description, String encodingType, Object location) {
        return ((Entity)((Entity)((Entity)this.newFeatureOfInterest().setProperty((Property)CommonProperties.EP_NAME, (Object)name)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)description)).setProperty((Property)CommonProperties.EP_ENCODINGTYPE, (Object)encodingType)).setProperty((Property)EP_FEATURE, location);
    }
}

