/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models;

import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.PkValue;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypePrimitive;
import de.fraunhofer.iosb.ilt.frostclient.models.CommonProperties;
import de.fraunhofer.iosb.ilt.frostclient.models.DataModel;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.MapValue;
import java.util.Map;

public class SensorThingsV11Projects
implements DataModel {
    public static final String NAME_USER = "User";
    public static final String NAME_USERS = "Users";
    public static final String NAME_ROLE = "Role";
    public static final String NAME_ROLES = "Roles";
    public static final String NAME_PROJECT = "Project";
    public static final String NAME_PROJECTS = "Projects";
    public static final String NAME_USERPROJECTROLE = "UserProjectRole";
    public static final String NAME_USERPROJECTROLES = "UserProjectRoles";
    public static final String NAME_EP_PUBLIC = "public";
    public static final String NAME_EP_RESTRICTED = "restricted";
    public static final String NAME_EP_ROLENAME = "rolename";
    public static final String NAME_EP_USERNAME = "username";
    public static final String NAME_EP_USERPASS = "userpass";
    public static final String NAME_NP_GENERATEDFEATURE = "GeneratedFeature";
    public static final String NAME_NP_GENERATEDFORLOCATIONS = "GeneratedForLocations";
    public static final EntityPropertyMain<Boolean> EP_PUBLIC = new EntityPropertyMain("public", TypePrimitive.EDM_BOOLEAN);
    public static final EntityPropertyMain<Boolean> EP_RESTRICTED = new EntityPropertyMain("restricted", TypePrimitive.EDM_BOOLEAN);
    public static final EntityPropertyMain<String> EP_ROLENAME = new EntityPropertyMain("rolename", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_USERNAME = new EntityPropertyMain("username", TypePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_USERPASS = new EntityPropertyMain("userpass", TypePrimitive.EDM_STRING);
    public final NavigationPropertyEntitySet npFeatureOfInterestGeneratedForLocations = new NavigationPropertyEntitySet("GeneratedForLocations");
    public final NavigationPropertyEntitySet npFeatureOfInterestProjects = new NavigationPropertyEntitySet("Projects");
    public final NavigationPropertyEntitySet npLocationGeneratedFeature = new NavigationPropertyEntitySet("GeneratedFeature", this.npFeatureOfInterestGeneratedForLocations);
    public final NavigationPropertyEntitySet npLocationProjects = new NavigationPropertyEntitySet("Projects");
    public final NavigationPropertyEntitySet npProjectFeaturesOfInterest = new NavigationPropertyEntitySet("FeaturesOfInterest", this.npFeatureOfInterestProjects);
    public final NavigationPropertyEntitySet npProjectLocations = new NavigationPropertyEntitySet("Locations", this.npLocationProjects);
    public final NavigationPropertyEntitySet npProjectSensors = new NavigationPropertyEntitySet("Sensors");
    public final NavigationPropertyEntitySet npProjectThings = new NavigationPropertyEntitySet("Things");
    public final NavigationPropertyEntitySet npProjectUserProjectRoles = new NavigationPropertyEntitySet("UserProjectRoles");
    public final NavigationPropertyEntitySet npRoleUserProjectRoles = new NavigationPropertyEntitySet("UserProjectRoles");
    public final NavigationPropertyEntitySet npRoleUsers = new NavigationPropertyEntitySet("Users");
    public final NavigationPropertyEntitySet npSensorProjects = new NavigationPropertyEntitySet("Projects", this.npProjectSensors);
    public final NavigationPropertyEntitySet npThingProjects = new NavigationPropertyEntitySet("Projects", this.npProjectThings);
    public final NavigationPropertyEntitySet npUserRoles = new NavigationPropertyEntitySet("Roles", this.npRoleUsers);
    public final NavigationPropertyEntitySet npUserUserProjectRoles = new NavigationPropertyEntitySet("UserProjectRoles");
    public final NavigationPropertyEntity npUserProjectRoleProject = new NavigationPropertyEntity("Project", this.npProjectUserProjectRoles);
    public final NavigationPropertyEntity npUserProjectRoleRole = new NavigationPropertyEntity("Role", this.npRoleUserProjectRoles);
    public final NavigationPropertyEntity npUserProjectRoleUser = new NavigationPropertyEntity("User", this.npUserUserProjectRoles);
    public final EntityType etProject = new EntityType("Project", "Projects");
    public final EntityType etRole = new EntityType("Role", "Roles");
    public final EntityType etUser = new EntityType("User", "Users");
    public final EntityType etUserProjectRole = new EntityType("UserProjectRole", "UserProjectRoles");
    private ModelRegistry mr;

    @Override
    public final void init(SensorThingsService service, ModelRegistry modelRegistry) {
        if (this.mr != null) {
            throw new IllegalArgumentException("Already initialised.");
        }
        this.mr = modelRegistry;
        this.mr.addDataModel(this);
        this.mr.registerEntityType(this.etProject);
        this.mr.registerEntityType(this.etRole);
        this.mr.registerEntityType(this.etUser);
        this.mr.registerEntityType(this.etUserProjectRole);
        this.etProject.registerProperty(CommonProperties.EP_ID).registerProperty(CommonProperties.EP_NAME).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(EP_PUBLIC).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npProjectFeaturesOfInterest).registerProperty(this.npProjectLocations).registerProperty(this.npProjectSensors).registerProperty(this.npProjectThings).registerProperty(this.npProjectUserProjectRoles);
        this.etRole.registerProperty(EP_ROLENAME).registerProperty(CommonProperties.EP_DESCRIPTION).registerProperty(CommonProperties.EP_PROPERTIES).registerProperty(this.npRoleUserProjectRoles).registerProperty(this.npRoleUsers);
        this.etUser.registerProperty(EP_USERNAME).registerProperty(EP_USERPASS).registerProperty(this.npUserRoles).registerProperty(this.npUserUserProjectRoles);
        this.etUserProjectRole.registerProperty(CommonProperties.EP_ID).registerProperty(this.npUserProjectRoleProject).registerProperty(this.npUserProjectRoleRole).registerProperty(this.npUserProjectRoleUser);
        this.mr.getEntityTypeForName("Datastream").registerProperty(EP_RESTRICTED);
        this.mr.getEntityTypeForName("FeatureOfInterest").registerProperty(EP_RESTRICTED).registerProperty(this.npFeatureOfInterestGeneratedForLocations).registerProperty(this.npFeatureOfInterestProjects);
        this.mr.getEntityTypeForName("Location").registerProperty(EP_RESTRICTED).registerProperty(this.npLocationGeneratedFeature);
        this.mr.getEntityTypeForName("Thing").registerProperty(EP_RESTRICTED).registerProperty(this.npThingProjects);
    }

    @Override
    public boolean isInitialised() {
        return this.mr != null;
    }

    public ModelRegistry getModelRegistry() {
        return this.mr;
    }

    public Entity newUser() {
        return new Entity(this.etUser);
    }

    public Entity newUser(String username, String password) {
        return ((Entity)this.newUser().setProperty((Property)EP_USERNAME, (Object)username)).setProperty((Property)EP_USERPASS, (Object)password);
    }

    public Entity newRole() {
        return new Entity(this.etRole);
    }

    public Entity newRole(String rolename, String description) {
        return ((Entity)this.newRole().setProperty((Property)EP_ROLENAME, (Object)rolename)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)description);
    }

    public Entity newRole(String rolename, String description, MapValue properties) {
        return this.newRole(rolename, description).setProperty((Property)CommonProperties.EP_PROPERTIES, (Object)properties);
    }

    public Entity newRole(String rolename, String description, Map<String, Object> properties) {
        return this.newRole(rolename, description, new MapValue(properties));
    }

    public Entity newProject() {
        return new Entity(this.etProject);
    }

    public Entity newProject(String projectname, String description) {
        return ((Entity)this.newProject().setProperty((Property)CommonProperties.EP_NAME, (Object)projectname)).setProperty((Property)CommonProperties.EP_DESCRIPTION, (Object)description);
    }

    public Entity newProject(String rolename, String description, MapValue properties) {
        return this.newProject(rolename, description).setProperty((Property)CommonProperties.EP_PROPERTIES, (Object)properties);
    }

    public Entity newProject(String rolename, String description, Map<String, Object> properties) {
        return this.newProject(rolename, description, new MapValue(properties));
    }

    public Entity newUserProjectRole() {
        return new Entity(this.etUserProjectRole);
    }

    public Entity newUserProjectRole(Object ... pk) {
        return this.newUserProjectRole().setPrimaryKeyValues(PkValue.of(pk));
    }

    public Entity newUserProjectRole(PkValue pk) {
        return this.newUserProjectRole().setPrimaryKeyValues(pk);
    }

    public Entity newUserProjectRole(Entity user, Entity project, Entity role) {
        return ((Entity)((Entity)this.newUserProjectRole().setProperty((Property)this.npUserProjectRoleUser, (Object)user)).setProperty((Property)this.npUserProjectRoleProject, (Object)project)).setProperty((Property)this.npUserProjectRoleRole, (Object)role);
    }
}

