/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.csdl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlItemComplexType;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlItemEntityContainer;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlItemEntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlItemTypeDefinition;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlPropertyNavigation;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlSchema;
import java.io.IOException;
import java.io.Writer;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="$Kind")
@JsonTypeIdResolver(value=SchemaItemIdResolver.class)
public interface CsdlSchemaItem {
    @JsonProperty(value="$Kind")
    public String getKind();

    public void writeXml(String var1, String var2, Writer var3) throws IOException;

    @JsonIgnore
    public CsdlDocument getDocument();

    @JsonIgnore
    public void setDocument(CsdlDocument var1);

    @JsonIgnore
    public CsdlSchema getSchema();

    @JsonIgnore
    public void setSchema(CsdlSchema var1);

    public static class SchemaItemIdResolver
    extends TypeIdResolverBase {
        private JavaType baseType;

        public void init(JavaType bt) {
            this.baseType = bt;
            super.init(bt);
        }

        public JavaType typeFromId(DatabindContext context, String id) throws IOException {
            if (id == null) {
                return TypeFactory.defaultInstance().constructSpecializedType(this.baseType, CsdlPropertyEntity.class);
            }
            switch (id) {
                case "ComplexType": {
                    return TypeFactory.defaultInstance().constructSpecializedType(this.baseType, CsdlItemComplexType.class);
                }
                case "EntityContainer": {
                    return TypeFactory.defaultInstance().constructSpecializedType(this.baseType, CsdlItemEntityContainer.class);
                }
                case "EntityType": {
                    return TypeFactory.defaultInstance().constructSpecializedType(this.baseType, CsdlItemEntityType.class);
                }
                case "TypeDefinition": {
                    return TypeFactory.defaultInstance().constructSpecializedType(this.baseType, CsdlItemTypeDefinition.class);
                }
                case "NavigationProperty": {
                    return TypeFactory.defaultInstance().constructSpecializedType(this.baseType, CsdlPropertyNavigation.class);
                }
                case "Property": 
                case "": {
                    return TypeFactory.defaultInstance().constructSpecializedType(this.baseType, CsdlPropertyEntity.class);
                }
            }
            throw new IllegalArgumentException("Unknown $kind: " + id);
        }

        public String idFromValue(Object value) {
            if (value instanceof CsdlSchemaItem) {
                CsdlSchemaItem si = (CsdlSchemaItem)value;
                return si.getKind();
            }
            return null;
        }

        public String idFromValueAndType(Object value, Class<?> suggestedType) {
            if (value instanceof CsdlSchemaItem) {
                CsdlSchemaItem si = (CsdlSchemaItem)value;
                return si.getKind();
            }
            return null;
        }

        public JsonTypeInfo.Id getMechanism() {
            return JsonTypeInfo.Id.CUSTOM;
        }
    }
}

