/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.csdl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlAnnotation;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.annotation.Annotation;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyAbstract;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CsdlPropertyNavigation
extends CsdlProperty {
    public static final String NAME_KIND_NAVIGATIONPROPERTY = "NavigationProperty";
    @JsonProperty(value="$Collection")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Boolean collection;
    @JsonProperty(value="$Partner")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String partner;
    @JsonProperty(value="$Type")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String type;
    @JsonProperty(value="$Nullable")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean nullable;
    @JsonIgnore
    private final List<CsdlAnnotation> annotations = new ArrayList<CsdlAnnotation>();

    public CsdlPropertyNavigation() {
        super(NAME_KIND_NAVIGATIONPROPERTY);
    }

    public CsdlPropertyNavigation fillFrom(CsdlDocument doc, String nameSpace, EntityType et, NavigationProperty np) {
        this.type = np.getType().getName();
        NavigationProperty inverse = np.getInverse();
        if (inverse != null) {
            this.partner = inverse.getName();
        }
        if (np.isEntitySet()) {
            this.collection = true;
        }
        this.nullable = np.isNullable();
        for (Annotation an : np.getAnnotations()) {
            this.annotations.add(CsdlAnnotation.of(doc, an));
        }
        return this;
    }

    @Override
    public void applyTo(ModelRegistry mr, EntityType entityType, String name) {
        NavigationPropertyAbstract np = this.createProperty(mr, name);
        entityType.registerProperty(np);
    }

    @Override
    public void applyTo(ModelRegistry mr, TypeComplex ct, String name) {
        NavigationPropertyAbstract np = this.createProperty(mr, name);
        ct.registerProperty(np);
    }

    private NavigationPropertyAbstract createProperty(ModelRegistry mr, String name) {
        NavigationPropertyAbstract np;
        EntityType targetType = mr.getEntityTypeForName(this.type);
        if (this.collection.booleanValue()) {
            NavigationPropertyEntitySet npc = new NavigationPropertyEntitySet(name);
            np = npc;
        } else {
            NavigationPropertyEntity npe = new NavigationPropertyEntity(name);
            np = npe;
        }
        np.setEntityType(targetType);
        np.setNullable(this.nullable);
        NavigationPropertyAbstract inverse = targetType.getNavigationProperty(this.partner);
        if (inverse != null) {
            np.setInverses(inverse);
        }
        return np;
    }

    @JsonAnyGetter
    public Map<String, Object> otherProperties() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (CsdlAnnotation annotation : this.annotations) {
            result.put("@" + annotation.getQualifiedName(), annotation.getValue());
        }
        return result;
    }

    @Override
    public void writeXml(String nameSpace, String name, Writer writer) throws IOException {
        Object finalType = this.type;
        if (this.collection != null && this.collection.booleanValue()) {
            finalType = "Collection(" + this.type + ")";
        }
        Object nullableString = "";
        if (this.nullable) {
            nullableString = " Nullable=\"" + Boolean.toString(this.nullable) + "\"";
        }
        Object partnerString = "";
        if (!StringHelper.isNullOrEmpty(this.partner)) {
            partnerString = " Partner=\"" + this.partner + "\"";
        }
        writer.write("<NavigationProperty Name=\"" + name + "\" Type=\"" + (String)finalType + "\"" + (String)nullableString + (String)partnerString);
        if (this.annotations.isEmpty()) {
            writer.write(" />");
        } else {
            writer.write(">");
            for (CsdlAnnotation an : this.annotations) {
                an.writeXml(writer);
            }
            writer.write("</NavigationProperty>");
        }
    }

    public CsdlPropertyNavigation setType(String type) {
        this.type = type;
        return this;
    }

    public CsdlPropertyNavigation setPartner(String partner) {
        this.partner = partner;
        return this;
    }

    public CsdlPropertyNavigation setNullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public CsdlPropertyNavigation setCollection(Boolean collection) {
        this.collection = collection;
        return this;
    }

    public static CsdlPropertyNavigation of(CsdlDocument doc, String nameSpace, EntityType et, NavigationProperty np) {
        return new CsdlPropertyNavigation().fillFrom(doc, nameSpace, et, np);
    }
}

