/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.json.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.PropertyType;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EntityDeserializer
extends JsonDeserializer<Entity> {
    private static final Map<ModelRegistry, Map<EntityType, EntityDeserializer>> instancePerModelAndType = new HashMap<ModelRegistry, Map<EntityType, EntityDeserializer>>();
    private final EntityType entityType;
    private final ModelRegistry modelRegistry;
    private final Map<String, PropertyData> propertyByName = new HashMap<String, PropertyData>();

    public static EntityDeserializer getInstance(ModelRegistry modelRegistry, EntityType entityType) {
        return instancePerModelAndType.computeIfAbsent(modelRegistry, t -> new HashMap()).computeIfAbsent(entityType, t -> new EntityDeserializer(modelRegistry, (EntityType)t));
    }

    public EntityDeserializer(ModelRegistry modelRegistry, EntityType entityType) {
        this.modelRegistry = modelRegistry;
        this.entityType = entityType;
        Set<Property> propertySet = entityType.getPropertySet();
        for (Property property : propertySet) {
            if (property instanceof EntityPropertyMain) {
                PropertyType type = property.getType();
                PropertyData propertyData = new PropertyData(property, false, type.getDeserializer(), type.getSerializer());
                for (String alias : ((EntityPropertyMain)property).getAliases()) {
                    this.propertyByName.put(alias, propertyData);
                }
                continue;
            }
            if (!(property instanceof NavigationProperty)) continue;
            NavigationProperty np = (NavigationProperty)property;
            this.propertyByName.put(property.getJsonName(), new PropertyData(property, np.isEntitySet()));
        }
    }

    public Entity deserializeFull(JsonParser parser, DeserializationContext ctxt) throws IOException {
        parser.nextToken();
        Entity result = this.deserialize(parser, ctxt);
        parser.nextToken();
        return result;
    }

    public Entity deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        Entity result = new Entity(this.entityType);
        boolean failOnUnknown = ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        JsonToken currentToken = parser.nextToken();
        while (currentToken == JsonToken.FIELD_NAME) {
            String fieldName = parser.currentName();
            parser.nextValue();
            if (fieldName.endsWith("@iot.count")) {
                this.deserialiseEntitySetCount(parser, fieldName, result);
            } else if (fieldName.endsWith("@iot.nextLink")) {
                this.deserialiseEntitySetNextLink(parser, fieldName, result);
            } else {
                PropertyData propertyData = this.propertyByName.get(fieldName);
                if (propertyData == null) {
                    if (failOnUnknown) {
                        String message = "Unknown field: " + fieldName + " on " + this.entityType.entityName + " expected one of: " + String.valueOf(this.propertyByName.keySet());
                        throw new UnrecognizedPropertyException(parser, message, parser.getCurrentLocation(), Entity.class, fieldName, null);
                    }
                    parser.readValueAsTree();
                } else {
                    this.deserializeProperty(parser, ctxt, result, propertyData);
                }
            }
            currentToken = parser.nextToken();
        }
        return result;
    }

    private void deserializeProperty(JsonParser parser, DeserializationContext ctxt, Entity result, PropertyData propertyData) throws IOException {
        if (propertyData.property instanceof EntityPropertyMain) {
            this.deserializeEntityProperty(parser, ctxt, propertyData, result);
        } else if (propertyData.property instanceof NavigationProperty) {
            this.deserializeNavigationProperty(propertyData, result, parser, ctxt);
        }
    }

    private void deserializeNavigationProperty(PropertyData propertyData, Entity result, JsonParser parser, DeserializationContext ctxt) throws IOException {
        NavigationProperty navPropertyMain = (NavigationProperty)propertyData.property;
        if (propertyData.isEntitySet) {
            this.deserialiseEntitySet(parser, ctxt, (NavigationPropertyEntitySet)navPropertyMain, result);
        } else {
            EntityType targetEntityType = navPropertyMain.getEntityType();
            Entity value = EntityDeserializer.getInstance(this.modelRegistry, targetEntityType).deserialize(parser, ctxt);
            result.setProperty((Property)navPropertyMain, (Object)value);
        }
    }

    private void deserializeEntityProperty(JsonParser parser, DeserializationContext ctxt, PropertyData propertyData, Entity result) throws IOException {
        EntityPropertyMain entityPropertyMain = (EntityPropertyMain)propertyData.property;
        if (propertyData.deserializer == null) {
            Object value = parser.readValueAs(Object.class);
            result.setProperty((Property)entityPropertyMain, value);
        } else {
            Object value = propertyData.deserializer.deserialize(parser, ctxt);
            result.setProperty((Property)entityPropertyMain, value);
        }
    }

    private void deserialiseEntitySetCount(JsonParser parser, String fieldName, Entity result) throws IOException {
        PropertyData propertyData = this.propertyByName.get(fieldName.substring(0, fieldName.indexOf(64)));
        if (propertyData == null) {
            return;
        }
        Property property = propertyData.property;
        if (property instanceof NavigationPropertyEntitySet) {
            NavigationPropertyEntitySet npes = (NavigationPropertyEntitySet)property;
            EntitySet entitySet = result.getProperty(npes);
            if (entitySet == null) {
                entitySet = new EntitySet(result, npes);
                result.setProperty((Property)npes, (Object)entitySet);
            }
            entitySet.setCount(parser.getLongValue());
        }
    }

    private void deserialiseEntitySetNextLink(JsonParser parser, String fieldName, Entity result) throws IOException {
        PropertyData propertyData = this.propertyByName.get(fieldName.substring(0, fieldName.indexOf(64)));
        if (propertyData == null) {
            return;
        }
        Property property = propertyData.property;
        if (property instanceof NavigationPropertyEntitySet) {
            NavigationPropertyEntitySet npes = (NavigationPropertyEntitySet)property;
            EntitySet entitySet = result.getProperty(npes);
            if (entitySet == null) {
                entitySet = new EntitySet(result, npes);
                result.setProperty((Property)npes, (Object)entitySet);
            }
            entitySet.setNextLink(parser.getValueAsString());
        }
    }

    private void deserialiseEntitySet(JsonParser parser, DeserializationContext ctxt, NavigationPropertyEntitySet navProperty, Entity result) throws IOException {
        EntityType setType = navProperty.getEntityType();
        EntitySet entitySet = result.getProperty(navProperty);
        if (entitySet == null) {
            entitySet = new EntitySet(result, navProperty);
            result.setProperty((Property)navProperty, (Object)entitySet);
        }
        EntityDeserializer setEntityDeser = EntityDeserializer.getInstance(this.modelRegistry, setType);
        JsonToken curToken = parser.nextToken();
        while (curToken != null && curToken != JsonToken.END_ARRAY) {
            entitySet.add(setEntityDeser.deserialize(parser, ctxt));
            curToken = parser.nextToken();
        }
    }

    private static class PropertyData {
        final Property property;
        final boolean isEntitySet;
        final JsonDeserializer deserializer;
        final JsonSerializer serializer;

        public PropertyData(Property property, boolean isEntitySet) {
            this(property, isEntitySet, null, null);
        }

        public PropertyData(Property property, boolean isEntitySet, JsonDeserializer deserializer, JsonSerializer serializer) {
            this.property = property;
            this.isEntitySet = isEntitySet;
            this.deserializer = deserializer;
            this.serializer = serializer;
        }
    }
}

