/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.auth;

import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.auth.AuthMethod;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import de.fraunhofer.iosb.ilt.frostclient.utils.Utils;
import de.fraunhofer.iosb.ilt.settings.ConfigProvider;
import de.fraunhofer.iosb.ilt.settings.Settings;
import de.fraunhofer.iosb.ilt.settings.annotation.DefaultValue;

public class AuthSettings
extends ConfigProvider<AuthSettings> {
    @DefaultValue(value="")
    public static final String TAG_AUTH_PROVIDER_CLASS = "providerClass";
    private AuthMethod authMethod;

    public AuthSettings(Settings settings) {
        super(settings);
    }

    public void load(SensorThingsService service) {
        String authProviderClassName = this.get(TAG_AUTH_PROVIDER_CLASS);
        if (StringHelper.isNullOrEmpty(authProviderClassName)) {
            if (this.authMethod != null) {
                this.authMethod.setAuth(service);
            }
            return;
        }
        AuthMethod authProvider = Utils.instantiateClass(authProviderClassName, AuthMethod.class);
        if (authProvider != null) {
            authProvider.setAuth(service);
        }
    }

    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    public AuthSettings setAuthMethod(AuthMethod authMethod) {
        this.authMethod = authMethod;
        return this.getThis();
    }

    public AuthSettings getThis() {
        return this;
    }
}

