/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.auth;

import com.google.gson.JsonElement;
import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorBoolean;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorNull;
import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.auth.AuthMethod;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthNone
implements AnnotatedConfigurable<Void, Void>,
AuthMethod {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthNone.class);
    @ConfigurableField(editor=EditorBoolean.class, label="IgnoreSslErrors", description="Ignore SSL certificate errors. This is a bad idea unless you know what you are doing.")
    @EditorBoolean.EdOptsBool
    private boolean ignoreSslErrors;

    public void configure(JsonElement config, Void context, Void edtCtx, ConfigEditor<?> ce) {
    }

    public ConfigEditor<?> getConfigEditor(Void context, Void edtCtx) {
        return new EditorNull();
    }

    @Override
    public void setAuth(SensorThingsService service) {
        try {
            HttpClientBuilder clientBuilder = service.getClientBuilder();
            if (this.ignoreSslErrors) {
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(new SSLContextBuilder().loadTrustMaterial((chain, authType) -> true).build());
                clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            }
            service.rebuildHttpClient();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
            LOGGER.error("Failed to initialise basic auth.", (Throwable)ex);
        }
    }
}

