/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient;

import java.util.HashMap;
import java.util.Map;

public class Version {
    public static final String VERSION_STA_V10_NAME = "v1.0";
    public static final String VERSION_STA_V11_NAME = "v1.1";
    public static final String VERSION_STA_V20_NAME = "v2.0";
    public static final Version V_1_0 = new Version("v1.0", "@iot.count", "@iot.id", "@iot.selfLink", "@iot.nextLink", "@iot.navigationLink");
    public static final Version V_1_1 = new Version("v1.1", "@iot.count", "@iot.id", "@iot.selfLink", "@iot.nextLink", "@iot.navigationLink");
    public static final Version V_2_0 = new Version("v2.0", "@count", "id", "@iot.selfLink", "@iot.nextLink", "@iot.navigationLink");
    public static final Version V_ODATA_4_01 = new Version("", "@count", "id", "@iot.selfLink", "@iot.nextLink", "@iot.navigationLink");
    public final String urlPart;
    public final String countName;
    public final String idName;
    public final String navLinkName;
    public final String nextLinkName;
    public final String selfLinkName;
    public static final Map<String, Version> VERSIONS = new HashMap<String, Version>();

    public static void registerVersion(Version version) {
        VERSIONS.put(version.urlPart, version);
    }

    public static Version findVersion(String urlPart) {
        return VERSIONS.get(urlPart);
    }

    public Version(String urlPart, String countName, String idName, String selfLinkName, String nextLinkName, String navLinkName) {
        this.urlPart = urlPart;
        this.countName = countName;
        this.idName = idName;
        this.selfLinkName = selfLinkName;
        this.nextLinkName = nextLinkName;
        this.navLinkName = navLinkName;
    }

    public String toString() {
        return this.urlPart;
    }

    public String getCountName() {
        return this.countName;
    }

    public String getIdName() {
        return this.idName;
    }

    public String getNavLinkName() {
        return this.navLinkName;
    }

    public String getNextLinkName() {
        return this.nextLinkName;
    }

    public String getSelfLinkName() {
        return this.selfLinkName;
    }

    public String getUrlPart() {
        return this.urlPart;
    }

    static {
        Version.registerVersion(V_1_0);
        Version.registerVersion(V_1_1);
    }
}

