/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient;

import de.fraunhofer.iosb.ilt.frostclient.auth.AuthSettings;
import de.fraunhofer.iosb.ilt.frostclient.models.DataModel;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import de.fraunhofer.iosb.ilt.settings.CachedSettings;
import de.fraunhofer.iosb.ilt.settings.ConfigProvider;
import de.fraunhofer.iosb.ilt.settings.Settings;
import de.fraunhofer.iosb.ilt.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.settings.annotation.DefaultValueInt;
import java.util.ArrayList;
import java.util.List;

public class ServiceSettings
extends ConfigProvider<ServiceSettings> {
    public static final String PREFIX_AUTH = "auth.";
    @DefaultValue(value="")
    public static final String TAG_SERVICE_BASE_URL = "baseUrl";
    @DefaultValue(value="")
    public static final String TAG_SERVICE_MQTT_URL = "mqttUrl";
    @DefaultValue(value="")
    public static final String TAG_SERVICE_MODEL_CLASS_LIST = "modelClasses";
    @DefaultValueInt(value=120000)
    public static final String TAG_SERVICE_HTTP_REQUEST_TIMEOUT = "requestTimeoutMs";
    final AuthSettings authSettings;

    public ServiceSettings() {
        super((Settings)new CachedSettings());
        this.authSettings = new AuthSettings((Settings)new CachedSettings(this.getSettings(), PREFIX_AUTH));
    }

    public ServiceSettings(Settings settings) {
        super(settings);
        this.authSettings = new AuthSettings((Settings)new CachedSettings(settings, PREFIX_AUTH));
    }

    public String getBaseUrl() {
        return this.get(TAG_SERVICE_BASE_URL);
    }

    public String getMqttUrl() {
        return this.get(TAG_SERVICE_MQTT_URL);
    }

    public int getRequestTimeoutMs() {
        return this.getInt(TAG_SERVICE_HTTP_REQUEST_TIMEOUT);
    }

    public List<DataModel> getModels() {
        String[] split;
        ArrayList<DataModel> result = new ArrayList<DataModel>();
        String classes = this.get(TAG_SERVICE_MODEL_CLASS_LIST);
        if (StringHelper.isNullOrEmpty(classes)) {
            return result;
        }
        for (String name : split = classes.split(",")) {
            try {
                Class<?> clazz = Class.forName(name, false, ((Object)((Object)this)).getClass().getClassLoader());
                if (!DataModel.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("Class " + name + " does not implement the interface DataModel");
                }
                Class<?> dataModelClass = clazz;
                DataModel dataModel = (DataModel)dataModelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                result.add(dataModel);
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalArgumentException("Failed to instantiate " + name + ".", ex);
            }
        }
        return result;
    }

    public AuthSettings getAuthSettings() {
        return this.authSettings;
    }

    public ServiceSettings getThis() {
        return this;
    }

    public static ServiceSettings of(Settings settings) {
        return new ServiceSettings(settings);
    }
}

