/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient;

import com.github.fge.jsonpatch.JsonPatchOperation;
import de.fraunhofer.iosb.ilt.frostclient.ServiceSettings;
import de.fraunhofer.iosb.ilt.frostclient.Version;
import de.fraunhofer.iosb.ilt.frostclient.auth.AuthMethod;
import de.fraunhofer.iosb.ilt.frostclient.dao.BaseDao;
import de.fraunhofer.iosb.ilt.frostclient.dao.Dao;
import de.fraunhofer.iosb.ilt.frostclient.exception.MqttException;
import de.fraunhofer.iosb.ilt.frostclient.exception.ServiceFailureException;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.JsonReader;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostclient.models.DataModel;
import de.fraunhofer.iosb.ilt.frostclient.query.Query;
import de.fraunhofer.iosb.ilt.frostclient.utils.MqttConfig;
import de.fraunhofer.iosb.ilt.frostclient.utils.MqttSubscription;
import de.fraunhofer.iosb.ilt.frostclient.utils.ParserUtils;
import de.fraunhofer.iosb.ilt.frostclient.utils.ServerInfo;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import de.fraunhofer.iosb.ilt.frostclient.utils.TokenManager;
import de.fraunhofer.iosb.ilt.frostclient.utils.Utils;
import de.fraunhofer.iosb.ilt.settings.Settings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorThingsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensorThingsService.class);
    public static final URL NULL_URL_V11;
    private final ModelRegistry modelRegistry;
    private final ServerInfo serverInfo = new ServerInfo();
    private JsonReader jsonReader;
    private String urlReplace;
    private HttpClientBuilder clientBuilder;
    private CloseableHttpClient httpClient;
    private MqttConfig mqttConfig;
    private MqttClient mqttClient;
    private final MqttCallback mqttCallback = new MqttCallbackExtended(){

        public void connectComplete(boolean reconnect, String serverURI) {
            LOGGER.info("MQTT connection established");
            try {
                SensorThingsService.this.mqttResubscribe();
            }
            catch (MqttException ex) {
                LOGGER.error("Failed to resubscribe to topics after connect.", (Throwable)ex);
            }
        }

        public void connectionLost(Throwable cause) {
            LOGGER.warn("MQTT connection lost, details in debug");
            LOGGER.debug("MQTT connection lost", cause);
        }

        public void messageArrived(String topic, MqttMessage message) throws Exception {
            SensorThingsService.this.handleMessage(topic, message);
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
            LOGGER.debug("Publish completed.");
        }
    };
    private final Map<String, Set<MqttSubscription>> mqttSubscriptions = new HashMap<String, Set<MqttSubscription>>();
    private ServiceSettings settings;
    private TokenManager tokenManager;
    private int requestTimeoutMs = 120000;
    private boolean initialised = false;

    public SensorThingsService(Settings settings) {
        this.settings = ServiceSettings.of(settings);
        this.modelRegistry = new ModelRegistry();
    }

    public SensorThingsService(DataModel ... models) {
        this(Arrays.asList(models));
    }

    public SensorThingsService(List<DataModel> models) {
        this.modelRegistry = new ModelRegistry();
        this.serverInfo.addModels(models);
    }

    public SensorThingsService(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
        modelRegistry.initFinalise();
        this.jsonReader = new JsonReader(modelRegistry);
    }

    public SensorThingsService setModels(List<DataModel> models) {
        this.serverInfo.addModels(models);
        return this;
    }

    public SensorThingsService setModels(DataModel ... models) {
        this.serverInfo.addModels(Arrays.asList(models));
        return this;
    }

    public SensorThingsService init() throws MalformedURLException {
        String mqttUrl;
        if (this.initialised) {
            return this;
        }
        this.getSettings();
        this.requestTimeoutMs = this.settings.getRequestTimeoutMs();
        if (this.serverInfo.getModels().isEmpty()) {
            this.serverInfo.addModels(this.settings.getModels());
        }
        if (!this.serverInfo.isBaseUrlSet()) {
            String baseUrl = this.settings.getBaseUrl();
            if (StringHelper.isNullOrEmpty(baseUrl)) {
                throw new IllegalArgumentException("Base URL must be set before init is called.");
            }
            this.setBaseUrl(URI.create(baseUrl));
        }
        this.settings.getAuthSettings().load(this);
        if (!this.serverInfo.isMqttUrlSet() && !StringHelper.isNullOrEmpty(mqttUrl = this.settings.getMqttUrl())) {
            this.serverInfo.setMqttUrl(mqttUrl);
        }
        if (!this.modelRegistry.isInitialised()) {
            Utils.detectServerInfo(this);
        }
        this.initModels();
        this.initialised = true;
        return this;
    }

    public ServiceSettings getSettings() {
        if (this.settings == null) {
            this.settings = new ServiceSettings();
        }
        return this.settings;
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    private void initModels() {
        for (DataModel model : this.serverInfo.getModels()) {
            model.init(this, this.modelRegistry);
        }
        this.modelRegistry.initFinalise();
        this.jsonReader = new JsonReader(this.modelRegistry);
    }

    public <T extends DataModel> T getModel(Class<T> clazz) {
        return this.modelRegistry.getModel(clazz);
    }

    public <T extends DataModel> boolean hasModel(Class<T> clazz) {
        return this.modelRegistry.hasModel(clazz);
    }

    public JsonReader getJsonReader() {
        return this.jsonReader;
    }

    public SensorThingsService setAuthMethod(AuthMethod authMethod) {
        this.getSettings().getAuthSettings().setAuthMethod(authMethod);
        return this;
    }

    public final SensorThingsService setBaseUrl(URI endpoint) throws MalformedURLException {
        return this.setBaseUrl(endpoint.toURL());
    }

    public final SensorThingsService setBaseUrl(URL endpoint) throws MalformedURLException {
        if (this.serverInfo.getBaseUrl() != null) {
            throw new IllegalStateException("endpoint URL already set.");
        }
        String url = StringUtils.removeEnd((String)endpoint.toString(), (String)"/");
        this.serverInfo.setBaseUrl(URI.create(url + "/").toURL());
        return this;
    }

    public final SensorThingsService setUrlReplace(String urlReplace) {
        this.urlReplace = urlReplace;
        return this;
    }

    public URL getBaseUrl() {
        if (this.serverInfo.getBaseUrl() == null) {
            throw new IllegalStateException("endpoint URL not set.");
        }
        return this.serverInfo.getBaseUrl();
    }

    public boolean isBaseUrlSet() {
        return this.serverInfo.getBaseUrl() != null;
    }

    public String getFullPathString(Entity parent, NavigationProperty relation) {
        return this.getBaseUrl().toString() + ParserUtils.relationPath(parent, relation);
    }

    public String getFullPathString(EntityType entityType) {
        return this.getBaseUrl().toString() + entityType.mainSet;
    }

    public URL getFullPath(Entity parent, NavigationProperty relation) throws ServiceFailureException {
        try {
            return new URL(this.getBaseUrl().toString() + ParserUtils.relationPath(parent, relation));
        }
        catch (MalformedURLException exc) {
            LOGGER.error("Failed to generate URL.", (Throwable)exc);
            throw new ServiceFailureException(exc);
        }
    }

    public URL getFullPath(EntityType entityType) throws ServiceFailureException {
        try {
            return new URL(this.getBaseUrl().toString() + entityType.mainSet);
        }
        catch (MalformedURLException exc) {
            LOGGER.error("Failed to generate URL.", (Throwable)exc);
            throw new ServiceFailureException(exc);
        }
    }

    public CloseableHttpResponse execute(HttpRequestBase request) throws IOException {
        String urlString = request.getURI().toString();
        if (!StringHelper.isNullOrEmpty(this.urlReplace) && urlString.startsWith(this.urlReplace)) {
            String newUrlString = this.serverInfo.getBaseUrl().toString() + urlString.substring(this.urlReplace.length());
            LOGGER.debug("   Fixed: {}", (Object)newUrlString);
            try {
                request.setURI(new URI(newUrlString));
            }
            catch (URISyntaxException ex) {
                throw new IOException("Failed to replace start of URL", ex);
            }
        }
        CloseableHttpClient client = this.getHttpClient();
        this.setTimeouts(request);
        if (this.tokenManager != null) {
            this.tokenManager.addAuthHeader((HttpRequest)request);
        }
        return client.execute((HttpUriRequest)request);
    }

    private SensorThingsService setTimeouts(HttpRequestBase request) {
        RequestConfig.Builder configBuilder = request.getConfig() == null ? RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT) : RequestConfig.copy((RequestConfig)request.getConfig());
        RequestConfig config = configBuilder.setSocketTimeout(this.requestTimeoutMs).setConnectTimeout(this.requestTimeoutMs).setConnectionRequestTimeout(this.requestTimeoutMs).build();
        request.setConfig(config);
        return this;
    }

    public Query query(EntityType type) {
        return new Query(this, type);
    }

    public Dao dao(EntityType type) {
        return new BaseDao(this, type);
    }

    public Entity create(Entity entity) throws ServiceFailureException {
        return new BaseDao(this, entity.getEntityType()).create(entity);
    }

    public void update(Entity entity) throws ServiceFailureException {
        new BaseDao(this, entity.getEntityType()).update(entity);
    }

    public void patch(Entity entity, List<JsonPatchOperation> patch) throws ServiceFailureException {
        new BaseDao(this, entity.getEntityType()).patch(entity, patch);
    }

    public void delete(Entity entity) throws ServiceFailureException {
        new BaseDao(this, entity.getEntityType()).delete(entity);
    }

    public SensorThingsService setTokenManager(TokenManager tokenManager) {
        if (tokenManager != null && this.httpClient != null) {
            tokenManager.setHttpClient(this.httpClient);
        }
        this.tokenManager = tokenManager;
        return this;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.getClientBuilder().build();
            if (this.tokenManager != null) {
                this.tokenManager.setHttpClient(this.httpClient);
            }
        }
        return this.httpClient;
    }

    public HttpClientBuilder getClientBuilder() {
        if (this.clientBuilder == null) {
            this.clientBuilder = HttpClients.custom().useSystemProperties();
        }
        return this.clientBuilder;
    }

    public void rebuildHttpClient() {
        this.httpClient = null;
    }

    public List<DataModel> getModels() {
        return Collections.unmodifiableList(this.serverInfo.getModels());
    }

    public Version getVersion() {
        return this.serverInfo.getVersion();
    }

    public SensorThingsService setVersion(Version version) {
        this.serverInfo.setVersion(version);
        return this;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public SensorThingsService setRequestTimeoutMs(int requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
        return this;
    }

    public MqttConfig getMqttConfig() {
        return this.mqttConfig;
    }

    public MqttConfig getOrCreateMqttConfig() {
        if (this.mqttConfig == null) {
            LOGGER.info("Using default MQTT configuration");
            this.mqttConfig = new MqttConfig();
        }
        return this.mqttConfig;
    }

    public void setMqttConfig(MqttConfig mqttConfig) {
        this.mqttConfig = mqttConfig;
    }

    public MqttSubscription subscribe(String topic, Consumer<Entity> handler, EntityType returnType) throws MqttException {
        MqttSubscription sub = new MqttSubscription(topic, returnType).setHandler(handler);
        this.subscribe(sub);
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(MqttSubscription sub) throws MqttException {
        this.ensureMqttConnected();
        Map<String, Set<MqttSubscription>> map = this.mqttSubscriptions;
        synchronized (map) {
            String topic = sub.getTopic();
            Set subSet = this.mqttSubscriptions.computeIfAbsent(topic, t -> new CopyOnWriteArraySet());
            if (subSet.add(sub) && subSet.size() == 1) {
                try {
                    this.mqttClient.subscribe(topic);
                }
                catch (org.eclipse.paho.client.mqttv3.MqttException exc) {
                    throw new MqttException(String.format("subscribing topic '%s' failed", topic), exc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribe(MqttSubscription sub) throws MqttException {
        String topic = sub.getTopic();
        Map<String, Set<MqttSubscription>> map = this.mqttSubscriptions;
        synchronized (map) {
            Set<MqttSubscription> subSet = this.mqttSubscriptions.get(topic);
            if (subSet == null) {
                LOGGER.info("No subscriptions found for topic {}", (Object)topic);
                return;
            }
            if (subSet.remove(sub) && subSet.isEmpty()) {
                this.mqttSubscriptions.remove(topic);
                try {
                    this.mqttClient.unsubscribe(topic);
                }
                catch (org.eclipse.paho.client.mqttv3.MqttException ex) {
                    throw new MqttException("Failed to unsubscribe", ex);
                }
            }
        }
    }

    public void unSubscribeAll(String topic) throws MqttException {
        this.mqttSubscriptions.remove(topic);
        if (this.mqttClient == null) {
            return;
        }
        try {
            this.mqttClient.unsubscribe(topic);
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException ex) {
            throw new MqttException("Failed to unsubscribe", ex);
        }
    }

    private void handleMessage(String topic, MqttMessage message) {
        for (MqttSubscription sub : this.mqttSubscriptions.getOrDefault(topic, Collections.emptySet())) {
            try {
                Entity entity = this.jsonReader.parseEntity(sub.getReturnType(), message.toString());
                entity.setService(this);
                Predicate<Entity> filter = sub.getFilter();
                if (filter != null && !filter.test(entity)) continue;
                sub.getHandler().accept(entity);
            }
            catch (IOException | RuntimeException ex) {
                LOGGER.error("Exception while handling message.", (Throwable)ex);
            }
        }
    }

    public boolean isMqttConnected() {
        return this.mqttClient != null && this.mqttClient.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mqttResubscribe() throws MqttException {
        this.ensureMqttConnected();
        Map<String, Set<MqttSubscription>> map = this.mqttSubscriptions;
        synchronized (map) {
            ArrayList<String> topics = new ArrayList<String>();
            int count = 0;
            for (String topic : this.mqttSubscriptions.keySet()) {
                topics.add(topic);
                if (++count != 100) continue;
                this.sendSubscribe(topics);
                count = 0;
                topics.clear();
            }
            if (count > 0) {
                this.sendSubscribe(topics);
                topics.clear();
            }
        }
    }

    private void sendSubscribe(List<String> topics) throws MqttException {
        try {
            this.mqttClient.subscribe((String[])topics.toArray(String[]::new));
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException ex) {
            throw new MqttException("Failed to resubscribe", ex);
        }
    }

    private void ensureMqttConnected() throws MqttException {
        this.ensureMqttConfigured();
        if (this.mqttClient.isConnected()) {
            return;
        }
        try {
            MqttConnectOptions options = this.mqttConfig.getOptions();
            if (this.mqttConfig.isAuthSet()) {
                options.setUserName(this.mqttConfig.getUsername());
                options.setPassword(this.mqttConfig.getPassword().toCharArray());
            }
            options.setAutomaticReconnect(true);
            this.mqttClient.connect(options);
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException exc) {
            throw new MqttException("MQTT connection failed", exc);
        }
    }

    private void ensureMqttConfigured() throws MqttException {
        if (this.mqttClient == null) {
            if (this.mqttConfig == null) {
                LOGGER.info("Using default MQTT configuration");
                this.mqttConfig = new MqttConfig();
            }
            try {
                this.mqttClient = new MqttClient(this.serverInfo.getMqttUrl(), this.mqttConfig.getClientId(), this.mqttConfig.getPersistence());
                this.mqttClient.setCallback(this.mqttCallback);
            }
            catch (org.eclipse.paho.client.mqttv3.MqttException exc) {
                throw new MqttException("could not create MQTT client", exc);
            }
        }
    }

    public void cleanupMqtt() {
        ArrayList<String> topics = new ArrayList<String>(this.mqttSubscriptions.keySet());
        topics.forEach(topic -> {
            try {
                this.unSubscribeAll((String)topic);
            }
            catch (MqttException ex) {
                LOGGER.warn("error unsubscribing from MQTT", (Throwable)ex);
            }
        });
        if (this.mqttClient != null) {
            if (this.mqttClient.isConnected()) {
                try {
                    this.mqttClient.disconnect();
                }
                catch (org.eclipse.paho.client.mqttv3.MqttException ex) {
                    LOGGER.warn("error disconnecting MQTT conection", (Throwable)ex);
                }
            }
            try {
                this.mqttClient.close(true);
            }
            catch (org.eclipse.paho.client.mqttv3.MqttException ex) {
                LOGGER.warn("error closing MQTT client", (Throwable)ex);
            }
        }
        this.mqttClient = null;
    }

    static {
        URL tempUrl = null;
        try {
            tempUrl = new URL("http://example.org/v1.1/");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        NULL_URL_V11 = tempUrl;
    }
}

