/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.swing;

import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorSubclass;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FilteringComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public final class FactorySubclsSwing
implements GuiFactorySwing {
    private final EditorSubclass<?, ?, ?> parentEditor;
    private EditorSubclass.classItem item;
    private String selectLabel = "Type:";
    private JPanel swComponent;
    private JPanel swItemHolder;
    private FilteringComboBox<String> swItems;
    private JPanel controls;

    public FactorySubclsSwing(EditorSubclass<?, ?, ?> parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public JComponent getComponent() {
        if (this.swComponent == null) {
            this.createGui();
        }
        return this.swComponent;
    }

    private void createGui() {
        String jsonName = this.parentEditor.getJsonName();
        this.item = this.parentEditor.findClassItem(jsonName);
        this.createComponent();
    }

    private void createComponent() {
        Set<String> classes = this.parentEditor.getClassesByDisplayName().keySet();
        this.controls = new JPanel(new FlowLayout(1));
        this.controls.add(new JLabel(this.selectLabel));
        this.swItems = new FilteringComboBox<String>(classes.toArray(new String[classes.size()]));
        this.controls.add(this.swItems);
        if (this.item != null) {
            this.swItems.setSelectedItem(this.item.displayName);
        } else {
            this.swItems.setSelectedItem(null);
        }
        JButton addButton = new JButton("Set");
        addButton.addActionListener(e -> this.setItem());
        this.controls.add(addButton);
        this.swItemHolder = new JPanel(new BorderLayout());
        this.swComponent = new JPanel(new BorderLayout());
        this.swComponent.setBorder(new EtchedBorder());
        this.swComponent.add((Component)this.controls, "North");
        this.swComponent.add((Component)this.swItemHolder, "Center");
        this.fillComponent();
    }

    private void setItem() {
        int idx = this.swItems.getSelectedIndex();
        if (idx >= 0) {
            String displayName = (String)this.swItems.getModel().getElementAt(idx);
            this.item = this.parentEditor.getClassesByDisplayName().get(displayName);
            this.parentEditor.setJsonName(this.item.jsonName);
        } else if (!this.parentEditor.isRestrictedClasses()) {
            String className = this.swItems.getSelectedItem().toString();
            this.parentEditor.setJsonName(className);
        }
    }

    public void fillComponent() {
        this.controls.setVisible(this.parentEditor.canEdit());
        String jsonName = this.parentEditor.getJsonName();
        this.item = this.parentEditor.findClassItem(jsonName);
        ConfigEditor classEditor = this.parentEditor.getClassEditor();
        Object label = jsonName == null || jsonName.isEmpty() ? "No Class selected." : (this.item == null ? "Manual: " + jsonName : "Selected: " + this.item.displayName);
        this.swItemHolder.removeAll();
        Dimension dim = new Dimension(5, 5);
        this.swItemHolder.add((Component)new Box.Filler(dim, dim, dim), "West");
        this.swItemHolder.add((Component)new JLabel((String)label), "North");
        if (classEditor == null) {
            JLabel noConf = new JLabel("Nothing to be configured.");
            this.swItemHolder.add((Component)noConf, "Center");
        } else {
            this.swItemHolder.add((Component)classEditor.getGuiFactorySwing().getComponent(), "Center");
        }
        this.swItemHolder.invalidate();
        this.swComponent.revalidate();
        this.swComponent.repaint();
    }

    public void setSelectLabel(String selectLabel) {
        this.selectLabel = selectLabel;
    }
}

