/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.swing;

import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorEnum;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class FactoryEnumSwing<T extends Enum<T>>
implements GuiFactorySwing {
    private final EditorEnum<T> parentEditor;
    private JComboBox<T> swComboBox;
    private ComboBoxModel<T> swModel;
    private JPanel swComponent;
    private final EditorEnum<T> outer;

    public FactoryEnumSwing(EditorEnum<T> parentEditor, EditorEnum<T> outer) {
        this.outer = outer;
        this.parentEditor = parentEditor;
    }

    @Override
    public JComponent getComponent() {
        if (this.swComponent == null) {
            this.createComponent();
        }
        return this.swComponent;
    }

    private void createComponent() {
        this.swModel = new DefaultComboBoxModel<Enum>((Enum[])this.outer.getSourceType().getEnumConstants());
        this.swComboBox = new JComboBox<T>(this.swModel);
        this.swComponent = new JPanel(new BorderLayout());
        this.swComponent.add(this.swComboBox, "Center");
        this.swComponent.add((Component)this.parentEditor.getHelpButton(), "West");
        this.fillComponent();
    }

    public void fillComponent() {
        this.swComboBox.setSelectedItem(this.outer.getRawValue());
    }

    public void readComponent() {
        int index = this.swComboBox.getSelectedIndex();
        this.outer.setRawValue((Enum)this.swModel.getElementAt(index));
    }
}

