/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.fx;

import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public final class FactoryListFx<U, T extends ConfigEditor<U>>
implements GuiFactoryFx {
    private final EditorList<U, T> parentEditor;
    private BorderPane fxPaneRoot;
    private GridPane fxPaneList;
    private Button addButton;
    private boolean vertical = true;
    private String text = "Add item";

    public FactoryListFx(EditorList<U, T> parentEditor, boolean vertical) {
        this.parentEditor = parentEditor;
        this.vertical = vertical;
        if (parentEditor.getMinCount() != parentEditor.getMaxCount()) {
            this.text = "Items:";
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public Pane getNode() {
        if (this.fxPaneRoot == null) {
            this.createPane();
        }
        return this.fxPaneRoot;
    }

    private void createPane() {
        FlowPane controls = new FlowPane();
        controls.setAlignment(Pos.TOP_LEFT);
        this.addButton = new Button("+");
        this.addButton.setOnAction(event -> this.parentEditor.addItem());
        controls.getChildren().add((Object)this.addButton);
        Label addLabel = new Label(this.text);
        addLabel.setAlignment(Pos.BASELINE_RIGHT);
        controls.getChildren().add((Object)addLabel);
        this.fxPaneList = new GridPane();
        this.fxPaneRoot = new BorderPane();
        this.fxPaneRoot.setStyle("    -fx-border-base: gray;    -fx-border-shadow: white;    -fx-light-border: derive(-fx-border-base, 25%);    -fx-border-color: -fx-light-border -fx-border-base -fx-border-base -fx-light-border;    -fx-border-insets: 0 1 1 0;    -fx-background-color: -fx-border-shadow, -fx-background;    -fx-background-insets: 1 0 0 1, 2;    -fx-padding: 2;");
        this.fxPaneRoot.setTop((Node)controls);
        this.fxPaneRoot.setCenter((Node)this.fxPaneList);
        this.fillComponent();
    }

    public void fillComponent() {
        if (this.fxPaneRoot == null) {
            this.createPane();
        }
        this.addButton.setVisible(this.parentEditor.canEdit());
        this.fxPaneList.getChildren().clear();
        if (this.parentEditor.getRawValue().isEmpty()) {
            this.fxPaneList.add((Node)new Label("No items added."), 0, 0);
        }
        int row = 0;
        for (ConfigEditor item : this.parentEditor.getRawValue()) {
            Node pane = item.getGuiFactoryFx().getNode();
            GridPane.setConstraints((Node)pane, (int)(this.vertical ? 0 : row), (int)(this.vertical ? row : 0), (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.BASELINE, (Priority)Priority.ALWAYS, (Priority)Priority.SOMETIMES);
            if (this.parentEditor.canEdit()) {
                VBox buttonBox = new VBox();
                Button removeButton = new Button("-");
                removeButton.setOnAction(event -> this.parentEditor.removeItem(item));
                buttonBox.getChildren().add((Object)removeButton);
                if (row > 0) {
                    int myRow = row;
                    Button upButton = new Button("\u2191");
                    upButton.setOnAction(event -> this.parentEditor.upItem(myRow));
                    buttonBox.getChildren().add((Object)upButton);
                }
                GridPane.setConstraints((Node)buttonBox, (int)(this.vertical ? 1 : row), (int)(this.vertical ? row : 1), (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
                this.fxPaneList.getChildren().addAll((Object[])new Node[]{pane, buttonBox});
            }
            ++row;
        }
    }
}

