/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurable.ContentConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.editor.AbstractEditorMap;
import java.util.HashMap;
import java.util.Map;

public class EditorMap<T>
extends AbstractEditorMap<Map<String, T>, T>
implements ContentConfigEditor<Map<String, T>> {
    public EditorMap() {
    }

    public EditorMap(int columns) {
        super(columns);
    }

    @Override
    public Map<String, T> getValue() throws ConfigurationException {
        HashMap result = new HashMap();
        for (String name : this.value) {
            AbstractEditorMap.Item item = (AbstractEditorMap.Item)this.options.get(name);
            Object val = item.editor.getValue();
            result.put(name, val);
        }
        return result;
    }

    @Override
    public Map<String, T> getDefaultValue() throws ConfigurationException {
        return new HashMap();
    }

    public double getDouble(String name, double deflt) throws ConfigurationException {
        AbstractEditorMap.Item item = (AbstractEditorMap.Item)this.options.get(name);
        Object result = item.editor.getValue();
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        return deflt;
    }

    public long getLong(String name, long deflt) throws ConfigurationException {
        AbstractEditorMap.Item item = (AbstractEditorMap.Item)this.options.get(name);
        Object result = item.editor.getValue();
        if (result instanceof Number) {
            return ((Number)result).longValue();
        }
        return deflt;
    }

    public Map<String, Long> getLongMap() throws ConfigurationException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (String name : this.value) {
            result.put(name, this.getLong(name, 0L));
        }
        return result;
    }

    @Override
    public void setValue(Map<String, T> value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

