/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemNumber;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.RootSchema;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDefault;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FactoryBigDecimalFx;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FactoryBigDecimalSwing;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Set;

public class EditorBigDecimal
extends EditorDefault<BigDecimal> {
    private BigDecimal min;
    private BigDecimal max;
    private BigDecimal dflt;
    private BigDecimal value;
    public Set<String> profilesEdit = AnnotationHelper.csvToReadOnlySet("");
    private String profile = "default";
    private FactoryBigDecimalSwing factorySwing;
    private FactoryBigDecimalFx factoryFx;

    public EditorBigDecimal() {
    }

    public EditorBigDecimal(BigDecimal min, BigDecimal max, BigDecimal deflt) {
        this.dflt = deflt;
        this.value = deflt;
        this.min = min;
        this.max = max;
    }

    public EditorBigDecimal(BigDecimal min, BigDecimal max, BigDecimal deflt, String label, String description) {
        this.dflt = deflt;
        this.value = deflt;
        this.min = min;
        this.max = max;
        this.setLabel(label);
        this.setDescription(description);
    }

    private BigDecimal fromDouble(double value) {
        if (value == Double.NEGATIVE_INFINITY || value == Double.POSITIVE_INFINITY || value == Double.NaN) {
            return null;
        }
        return new BigDecimal(value);
    }

    @Override
    public void initFor(Field field) {
        EdOptsBigDecimal annotation = field.getAnnotation(EdOptsBigDecimal.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Field must have an EdOptsDouble annotation to use this editor: " + field.getName());
        }
        this.min = this.fromDouble(annotation.min());
        this.max = this.fromDouble(annotation.max());
        if (!annotation.dfltIsNull()) {
            this.dflt = new BigDecimal(annotation.dflt());
        }
        this.value = this.dflt;
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(annotation.profilesEdit());
    }

    @Override
    public void setConfig(JsonElement config) {
        this.value = config != null && config.isJsonPrimitive() ? config.getAsBigDecimal() : this.dflt;
        this.fillComponent();
    }

    @Override
    public JsonElement getConfig() {
        this.readComponent();
        if (this.value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive((Number)this.value);
    }

    @Override
    public SchemaItem getJsonSchema(RootSchema rootSchema) {
        ItemNumber item = (ItemNumber)((ItemNumber)((ItemNumber)new ItemNumber().setDeflt(this.dflt)).setTitle(this.getLabel())).setDescription(this.getDescription());
        if (this.min != null) {
            item.setMinimum(this.min);
        }
        if (this.max != null) {
            item.setMaximum(this.max);
        }
        if (rootSchema == null) {
            return new RootSchema(item);
        }
        return item;
    }

    @Override
    public GuiFactorySwing getGuiFactorySwing() {
        if (this.factoryFx != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factorySwing == null) {
            this.factorySwing = new FactoryBigDecimalSwing(this);
        }
        return this.factorySwing;
    }

    @Override
    public GuiFactoryFx getGuiFactoryFx() {
        if (this.factorySwing != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factoryFx == null) {
            this.factoryFx = new FactoryBigDecimalFx(this);
        }
        return this.factoryFx;
    }

    private void fillComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    private void readComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.readComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.readComponent();
        }
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public BigDecimal getDeflt() {
        return this.dflt;
    }

    public BigDecimal getRawValue() {
        return this.value;
    }

    public void setRawValue(BigDecimal value) {
        if (this.min != null && this.min.compareTo(value) > 0) {
            value = this.min;
        }
        if (this.max != null && this.max.compareTo(value) < 0) {
            value = this.max;
        }
        this.value = value;
    }

    @Override
    public BigDecimal getValue() {
        this.readComponent();
        return this.value;
    }

    @Override
    public BigDecimal getDefaultValue() {
        return this.dflt;
    }

    @Override
    public void setValue(BigDecimal value) {
        this.value = value;
        this.fillComponent();
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
        this.fillComponent();
    }

    public void setProfilesEdit(String csv) {
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(csv);
    }

    @Override
    public boolean canEdit() {
        return this.profilesEdit.contains(this.profile);
    }

    @Override
    public boolean isDefault() {
        this.readComponent();
        return this.dflt == this.value;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EdOptsBigDecimal {
        public double min() default -Infinity;

        public double max() default Infinity;

        public double dflt() default 0.0;

        public boolean dfltIsNull() default false;

        public String profilesEdit() default "";
    }
}

