/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.impl;

import de.focus_shift.jollyday.core.Holiday;
import de.focus_shift.jollyday.core.HolidayType;
import de.focus_shift.jollyday.core.impl.DefaultHolidayManager;
import de.focus_shift.jollyday.core.util.CalendarUtil;
import java.time.LocalDate;
import java.time.Year;
import java.util.HashSet;
import java.util.Set;

public class JapaneseHolidayManager
extends DefaultHolidayManager {
    private static final String BRIDGING_HOLIDAY_PROPERTIES_KEY = "BRIDGING_HOLIDAY";

    @Override
    public Set<Holiday> getHolidays(Year year, String ... args) {
        Set<Holiday> holidays = super.getHolidays(year, args);
        HashSet<Holiday> bridgingHolidays = new HashSet<Holiday>();
        for (Holiday holiday : holidays) {
            LocalDate twoDaysLater = holiday.getDate().plusDays(2L);
            LocalDate bridgingDate = twoDaysLater.minusDays(1L);
            if (!CalendarUtil.contains(holidays, twoDaysLater) || CalendarUtil.contains(holidays, bridgingDate)) continue;
            bridgingHolidays.add(new Holiday(bridgingDate, BRIDGING_HOLIDAY_PROPERTIES_KEY, HolidayType.PUBLIC_HOLIDAY));
        }
        holidays.addAll(bridgingHolidays);
        return holidays;
    }
}

