/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io;

import de.flapdoodle.embed.process.io.ConsoleOutputStreamProcessor;
import de.flapdoodle.embed.process.io.NamedOutputStreamProcessor;
import de.flapdoodle.embed.process.io.NullProcessor;
import de.flapdoodle.embed.process.io.ReaderProcessor;
import de.flapdoodle.embed.process.io.Slf4jLevel;
import de.flapdoodle.embed.process.io.Slf4jStreamProcessor;
import de.flapdoodle.embed.process.io.StreamProcessor;
import java.io.Reader;
import org.slf4j.Logger;

public class Processors {
    private Processors() {
        throw new IllegalAccessError("singleton");
    }

    public static StreamProcessor console() {
        return new ConsoleOutputStreamProcessor();
    }

    public static StreamProcessor silent() {
        return new NullProcessor();
    }

    public static StreamProcessor named(String name, StreamProcessor destination) {
        return new NamedOutputStreamProcessor(name, destination);
    }

    public static StreamProcessor namedConsole(String name) {
        return Processors.named(name, Processors.console());
    }

    public static StreamProcessor logTo(Logger logger, Slf4jLevel level) {
        return new Slf4jStreamProcessor(logger, level);
    }

    public static ReaderProcessor connect(Reader reader, StreamProcessor processor) {
        return new ReaderProcessor(reader, processor);
    }
}

