/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.process.io.Files;
import de.flapdoodle.embed.process.io.directories.TempDir;
import de.flapdoodle.embed.process.io.directories.UUIDNaming;
import de.flapdoodle.embed.process.transitions.ImmutableInitTempDirectory;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.naming.HasLabel;
import de.flapdoodle.types.Try;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.immutables.value.Value;

@Value.Immutable
public abstract class InitTempDirectory
implements Transition<TempDir>,
HasLabel {
    public String transitionLabel() {
        return "InitTempDirectory";
    }

    @Value.Default
    protected Supplier<TempDir> tempDirFactory() {
        return () -> TempDir.platformTempDir().get();
    }

    @Value.Default
    protected boolean deleteIfEmpty() {
        return false;
    }

    @Value.Default
    protected boolean forceDelete() {
        return false;
    }

    public StateID<TempDir> destination() {
        return StateID.of(TempDir.class);
    }

    public Set<StateID<?>> sources() {
        return Collections.emptySet();
    }

    public State<TempDir> result(StateLookup lookup) {
        return State.of((Object)this.tempDirFactory().get(), (TearDown[])new TearDown[]{it -> Try.run(() -> {
            if (this.forceDelete()) {
                Files.deleteAll((Path)it.value());
            } else if (this.deleteIfEmpty()) {
                Preconditions.checkArgument((boolean)Files.isEmptyDirectory((Path)it.value()), (String)"temp directory %s is not empty, (forceDelete=%s)", (Object[])new Object[]{it.value(), this.forceDelete()});
                Files.deleteAll((Path)it.value());
            }
        })});
    }

    public static ImmutableInitTempDirectory withPlatformTemp() {
        return InitTempDirectory.builder().build();
    }

    public static ImmutableInitTempDirectory.Builder builder() {
        return ImmutableInitTempDirectory.builder();
    }

    public static ImmutableInitTempDirectory with(Path path) {
        return InitTempDirectory.builder().tempDirFactory(() -> TempDir.of(path)).build();
    }

    public static ImmutableInitTempDirectory withPlatformTempRandomSubDir() {
        return InitTempDirectory.builder().tempDirFactory(TempDir.platformTempSubDir(new UUIDNaming())).deleteIfEmpty(true).build();
    }
}

