/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.store.ExtractedFileSetStore;
import de.flapdoodle.embed.process.store.ExtractedFileSets;
import de.flapdoodle.types.Try;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.UUID;

public class ContentHashExtractedFileSetStore
implements ExtractedFileSetStore {
    private static final int HASH_BUFFER_SIZE = 0x100000;
    private final Path basePath;
    private final Path cachePath;

    public ContentHashExtractedFileSetStore(Path basePath) {
        this.basePath = basePath;
        this.cachePath = basePath.resolve("hashes");
        if (!Files.exists(basePath, new LinkOption[0])) {
            Try.run(() -> Files.createDirectory(basePath, new FileAttribute[0]));
        }
        if (!Files.exists(this.cachePath, new LinkOption[0])) {
            Try.run(() -> Files.createDirectory(this.cachePath, new FileAttribute[0]));
        }
    }

    @Override
    public Optional<ExtractedFileSet> extractedFileSet(Path archive, FileSet fileSet) {
        String hash = ContentHashExtractedFileSetStore.archiveContentAndFileSetDescriptionHash(this.cachePath, archive, fileSet);
        Path fileSetBasePath = this.basePath.resolve(hash);
        if (Files.isDirectory(fileSetBasePath, new LinkOption[0])) {
            return (Optional)Try.supplier(() -> Optional.of(ExtractedFileSets.readFileSet(fileSetBasePath, fileSet))).fallbackTo(ex -> Optional.empty()).get();
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtractedFileSet store(Path archive, FileSet fileSet, ExtractedFileSet src) throws IOException {
        String hash = ContentHashExtractedFileSetStore.archiveContentAndFileSetDescriptionHash(this.cachePath, archive, fileSet);
        Path fileSetBasePath = this.basePath.resolve(hash);
        Path tempCopyDir = this.basePath.resolve("store-" + UUID.randomUUID());
        Preconditions.checkArgument((!Files.exists(tempCopyDir, new LinkOption[0]) ? 1 : 0) != 0, (String)"temp copy directory already exists: %s", (Object[])new Object[]{tempCopyDir});
        try {
            block7: {
                Files.createDirectory(tempCopyDir, new FileAttribute[0]);
                ExtractedFileSets.makeCopyOf(tempCopyDir, fileSet, src);
                if (!Files.exists(fileSetBasePath, new LinkOption[0])) {
                    try {
                        Files.move(tempCopyDir, fileSetBasePath, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (FileSystemException fx) {
                        if (Files.exists(fileSetBasePath, new LinkOption[0])) break block7;
                        throw new IOException("move " + tempCopyDir + " to " + fileSetBasePath + " failed, but " + fileSetBasePath + " still does not exist");
                    }
                }
            }
            ExtractedFileSet extractedFileSet = ExtractedFileSets.readFileSet(fileSetBasePath, fileSet);
            return extractedFileSet;
        }
        finally {
            if (Files.exists(tempCopyDir, new LinkOption[0])) {
                de.flapdoodle.embed.process.io.Files.deleteAll(tempCopyDir);
            }
        }
    }

    static String archiveContentAndFileSetDescriptionHash(Path cachePath, Path archive, FileSet fileSet) {
        Preconditions.checkArgument((boolean)Files.exists(cachePath, LinkOption.NOFOLLOW_LINKS), (String)"cache does not exsist: %s", (Object[])new Object[]{cachePath});
        Preconditions.checkArgument((boolean)Files.isDirectory(cachePath, LinkOption.NOFOLLOW_LINKS), (String)"cache is not a directory: %s", (Object[])new Object[]{cachePath});
        String cacheKey = ExtractedFileSets.archiveAndFileSetDescriptionHashOrException(archive, fileSet);
        return ContentHashExtractedFileSetStore.readOrCreateArchiveContentAndFileSetDescriptionHash(cachePath.resolve(cacheKey), archive, fileSet);
    }

    private static String readOrCreateArchiveContentAndFileSetDescriptionHash(Path cachedHashPath, Path archive, FileSet fileSet) {
        if (Files.exists(cachedHashPath, new LinkOption[0])) {
            return ContentHashExtractedFileSetStore.readHash(cachedHashPath);
        }
        String hash = ExtractedFileSets.archiveContentAndFileSetDescriptionHash(archive, fileSet, 0x100000);
        Try.run(() -> Files.write(cachedHashPath, hash.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
        return hash;
    }

    private static String readHash(Path cachedHashPath) {
        byte[] hashBytes = (byte[])Try.supplier(() -> Files.readAllBytes(cachedHashPath)).mapToUncheckedException(ex -> new RuntimeException("could not read cached key from " + cachedHashPath, (Throwable)ex)).get();
        return new String(hashBytes, StandardCharsets.UTF_8);
    }
}

