/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import de.flapdoodle.embed.mongo.client.AuthenticationSetup;
import de.flapdoodle.embed.mongo.client.ClientActions;
import de.flapdoodle.embed.mongo.client.ExecuteMongoClientAction;
import de.flapdoodle.embed.mongo.client.UsernamePassword;
import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.spring.autoconfigure.MongodWrapper;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.reverse.Listener;
import java.io.Closeable;
import java.util.Optional;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;

public abstract class AbstractServerFactory<C extends Closeable> {
    private final MongoProperties properties;
    private final ExecuteMongoClientAction<C> adapter;

    protected AbstractServerFactory(MongoProperties properties, ExecuteMongoClientAction<C> adapter) {
        this.properties = properties;
        this.adapter = adapter;
    }

    public final MongodWrapper createWrapper(IFeatureAwareVersion version, Mongod mongod, MongodArguments mongodArguments) {
        return new MongodWrapper(mongod.transitions((Version)version), this.addAuthUserToDB(this.properties), this.initReplicaSet(version, this.properties, mongodArguments));
    }

    private Listener addAuthUserToDB(MongoProperties properties) {
        String username = properties.getUsername();
        char[] password = properties.getPassword();
        String databaseName = properties.getMongoClientDatabase();
        if (username != null && password != null) {
            return ClientActions.setupAuthentication(this.adapter, (String)databaseName, (AuthenticationSetup)AuthenticationSetup.of((UsernamePassword)UsernamePassword.of((String)username, (char[])password)));
        }
        return Listener.builder().build();
    }

    private Listener initReplicaSet(IFeatureAwareVersion version, MongoProperties properties, MongodArguments mongodArguments) {
        String username = properties.getUsername();
        char[] password = properties.getPassword();
        Optional replication = mongodArguments.replication();
        if (replication.isPresent()) {
            return ClientActions.initReplicaSet(this.adapter, (IFeatureAwareVersion)version, (Storage)((Storage)replication.get()), username != null ? Optional.of(UsernamePassword.of((String)username, (char[])password)) : Optional.empty());
        }
        return Listener.builder().build();
    }
}

