/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageFinder;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableUrlTemplatePackageFinder
extends UrlTemplatePackageFinder {
    private final ArchiveType archiveType;
    private final FileSet fileSet;
    private final String urlTemplate;
    private final boolean isDevVersion;

    private ImmutableUrlTemplatePackageFinder(Builder builder) {
        this.archiveType = builder.archiveType;
        this.fileSet = builder.fileSet;
        this.urlTemplate = builder.urlTemplate;
        this.isDevVersion = builder.isDevVersionIsSet() ? builder.isDevVersion : super.isDevVersion();
    }

    private ImmutableUrlTemplatePackageFinder(ArchiveType archiveType, FileSet fileSet, String urlTemplate, boolean isDevVersion) {
        this.archiveType = archiveType;
        this.fileSet = fileSet;
        this.urlTemplate = urlTemplate;
        this.isDevVersion = isDevVersion;
    }

    @Override
    protected ArchiveType archiveType() {
        return this.archiveType;
    }

    @Override
    protected FileSet fileSet() {
        return this.fileSet;
    }

    @Override
    String urlTemplate() {
        return this.urlTemplate;
    }

    @Override
    protected boolean isDevVersion() {
        return this.isDevVersion;
    }

    public final ImmutableUrlTemplatePackageFinder withArchiveType(ArchiveType value) {
        ArchiveType newValue = Objects.requireNonNull(value, "archiveType");
        if (this.archiveType == newValue) {
            return this;
        }
        return new ImmutableUrlTemplatePackageFinder(newValue, this.fileSet, this.urlTemplate, this.isDevVersion);
    }

    public final ImmutableUrlTemplatePackageFinder withFileSet(FileSet value) {
        if (this.fileSet == value) {
            return this;
        }
        FileSet newValue = Objects.requireNonNull(value, "fileSet");
        return new ImmutableUrlTemplatePackageFinder(this.archiveType, newValue, this.urlTemplate, this.isDevVersion);
    }

    public final ImmutableUrlTemplatePackageFinder withUrlTemplate(String value) {
        String newValue = Objects.requireNonNull(value, "urlTemplate");
        if (this.urlTemplate.equals(newValue)) {
            return this;
        }
        return new ImmutableUrlTemplatePackageFinder(this.archiveType, this.fileSet, newValue, this.isDevVersion);
    }

    public final ImmutableUrlTemplatePackageFinder withIsDevVersion(boolean value) {
        if (this.isDevVersion == value) {
            return this;
        }
        return new ImmutableUrlTemplatePackageFinder(this.archiveType, this.fileSet, this.urlTemplate, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUrlTemplatePackageFinder && this.equalsByValue((ImmutableUrlTemplatePackageFinder)another);
    }

    private boolean equalsByValue(ImmutableUrlTemplatePackageFinder another) {
        return this.archiveType.equals((Object)another.archiveType) && this.fileSet.equals(another.fileSet) && this.urlTemplate.equals(another.urlTemplate) && this.isDevVersion == another.isDevVersion;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.archiveType.hashCode();
        h += (h << 5) + this.fileSet.hashCode();
        h += (h << 5) + this.urlTemplate.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isDevVersion);
        return h;
    }

    public String toString() {
        return "UrlTemplatePackageFinder{archiveType=" + this.archiveType + ", fileSet=" + this.fileSet + ", urlTemplate=" + this.urlTemplate + ", isDevVersion=" + this.isDevVersion + "}";
    }

    public static ImmutableUrlTemplatePackageFinder copyOf(UrlTemplatePackageFinder instance) {
        if (instance instanceof ImmutableUrlTemplatePackageFinder) {
            return (ImmutableUrlTemplatePackageFinder)instance;
        }
        return ImmutableUrlTemplatePackageFinder.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ARCHIVE_TYPE = 1L;
        private static final long INIT_BIT_FILE_SET = 2L;
        private static final long INIT_BIT_URL_TEMPLATE = 4L;
        private static final long OPT_BIT_IS_DEV_VERSION = 1L;
        private long initBits = 7L;
        private long optBits;
        private ArchiveType archiveType;
        private FileSet fileSet;
        private String urlTemplate;
        private boolean isDevVersion;

        private Builder() {
        }

        public final Builder from(UrlTemplatePackageFinder instance) {
            Objects.requireNonNull(instance, "instance");
            this.archiveType(instance.archiveType());
            this.fileSet(instance.fileSet());
            this.urlTemplate(instance.urlTemplate());
            this.isDevVersion(instance.isDevVersion());
            return this;
        }

        public final Builder archiveType(ArchiveType archiveType) {
            this.archiveType = Objects.requireNonNull(archiveType, "archiveType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fileSet(FileSet fileSet) {
            this.fileSet = Objects.requireNonNull(fileSet, "fileSet");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder urlTemplate(String urlTemplate) {
            this.urlTemplate = Objects.requireNonNull(urlTemplate, "urlTemplate");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder isDevVersion(boolean isDevVersion) {
            this.isDevVersion = isDevVersion;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableUrlTemplatePackageFinder build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUrlTemplatePackageFinder(this);
        }

        private boolean isDevVersionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("archiveType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fileSet");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("urlTemplate");
            }
            return "Cannot build UrlTemplatePackageFinder, some of required attributes are not set " + attributes;
        }
    }
}

