/*
 * Decompiled with CFR 0.152.
 */
package de.fayard.refreshVersions.core.internal;

import de.fayard.refreshVersions.core.Version;
import de.fayard.refreshVersions.core.extensions.gradle.ProjectKt;
import de.fayard.refreshVersions.core.extensions.text.CharSequenceKt;
import de.fayard.refreshVersions.core.internal.OutputFile;
import de.fayard.refreshVersions.core.internal.PluginWithVersionCandidates;
import de.fayard.refreshVersions.core.internal.TaggedRange;
import de.fayard.refreshVersions.core.internal.codeparsing.SourceCodeSection;
import de.fayard.refreshVersions.core.internal.codeparsing.gradle.GradleScriptParsingKt;
import de.fayard.refreshVersions.core.internal.codeparsing.gradle.PluginBlocksLocatingKt;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bJ+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0000\u00a2\u0006\u0002\b\u0012J2\u0010\u0013\u001a\u00020\u0004*\u00060\u0014j\u0002`\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0015\u0010\u0018\u001a\u00020\u0004*\u00060\u0014j\u0002`\u0015H\u0000\u00a2\u0006\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lde/fayard/refreshVersions/core/internal/SettingsPluginsUpdater;", "", "()V", "updateGradleSettingsWithAvailablePluginsUpdates", "", "settingsFile", "Ljava/io/File;", "settingsPluginsUpdates", "", "Lde/fayard/refreshVersions/core/internal/PluginWithVersionCandidates;", "rootProject", "Lorg/gradle/api/Project;", "buildSrcSettingsPluginsUpdates", "updatedGradleSettingsFileContentWithAvailablePluginsUpdates", "", "fileContent", "isKotlinDsl", "", "updatedGradleSettingsFileContentWithAvailablePluginsUpdates$refreshVersions_core", "insertAvailableVersionComments", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "pluginBlockRange", "Lde/fayard/refreshVersions/core/internal/TaggedRange;", "removeCommentsAddedByUs", "removeCommentsAddedByUs$refreshVersions_core", "PluginIdRegexes", "refreshVersions-core"})
public final class SettingsPluginsUpdater {
    @NotNull
    public static final SettingsPluginsUpdater INSTANCE;

    public final void updateGradleSettingsWithAvailablePluginsUpdates(@NotNull Project rootProject, @NotNull List<PluginWithVersionCandidates> settingsPluginsUpdates, @NotNull List<PluginWithVersionCandidates> buildSrcSettingsPluginsUpdates) {
        block7: {
            File file;
            File file2;
            File file3;
            File file4;
            Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
            Intrinsics.checkNotNullParameter(settingsPluginsUpdates, (String)"settingsPluginsUpdates");
            Intrinsics.checkNotNullParameter(buildSrcSettingsPluginsUpdates, (String)"buildSrcSettingsPluginsUpdates");
            boolean bl = ProjectKt.isRootProject(rootProject);
            if (!bl) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            boolean bl2 = bl = !ProjectKt.isBuildSrc(rootProject);
            if (!bl) {
                String string3 = "Failed requirement.";
                throw new IllegalArgumentException(string3.toString());
            }
            File kotlinDslSettings = file4 = rootProject.file((Object)"settings.gradle.kts");
            boolean bl3 = false;
            if (kotlinDslSettings.exists()) {
                file3 = kotlinDslSettings;
            } else {
                File file5;
                File it = file5 = rootProject.file((Object)"settings.gradle");
                boolean bl4 = false;
                boolean bl5 = it.exists();
                if (!bl5) {
                    String string4 = "Check failed.";
                    throw new IllegalStateException(string4.toString());
                }
                file3 = file5;
            }
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"rootProject.file(\"settin\u2026}\n            }\n        }");
            File rootProjectSettingsFile = file3;
            File kotlinDslSettings2 = file2 = rootProject.file((Object)"buildSrc/settings.gradle.kts");
            boolean bl6 = false;
            if (kotlinDslSettings2.exists()) {
                file = kotlinDslSettings2;
            } else {
                File file6;
                File it = file6 = rootProject.file((Object)"buildSrc/settings.gradle");
                boolean bl7 = false;
                file = it.exists() ? file6 : null;
            }
            File buildSrcSettingsFile = file;
            this.updateGradleSettingsWithAvailablePluginsUpdates(rootProjectSettingsFile, settingsPluginsUpdates);
            File file7 = buildSrcSettingsFile;
            if (file7 == null) break block7;
            File it = file2 = file7;
            boolean bl8 = false;
            INSTANCE.updateGradleSettingsWithAvailablePluginsUpdates(it, buildSrcSettingsPluginsUpdates);
        }
    }

    private final void updateGradleSettingsWithAvailablePluginsUpdates(File settingsFile, List<PluginWithVersionCandidates> settingsPluginsUpdates) {
        String oldContent = FilesKt.readText$default((File)settingsFile, null, (int)1, null);
        String string2 = settingsFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"settingsFile.name");
        boolean isKotlinDsl = StringsKt.endsWith$default((String)string2, (String)".kts", (boolean)false, (int)2, null);
        String newContent = this.updatedGradleSettingsFileContentWithAvailablePluginsUpdates$refreshVersions_core(oldContent, isKotlinDsl, settingsPluginsUpdates);
        if (Intrinsics.areEqual((Object)oldContent, (Object)newContent) ^ true) {
            FilesKt.writeText$default((File)settingsFile, (String)newContent, null, (int)2, null);
            OutputFile.logFileWasModified$default(isKotlinDsl ? OutputFile.SETTINGS_GRADLE_KTS : OutputFile.SETTINGS_GRADLE, false, 1, null);
        }
    }

    @NotNull
    public final String updatedGradleSettingsFileContentWithAvailablePluginsUpdates$refreshVersions_core(@NotNull String fileContent, boolean isKotlinDsl, @NotNull List<PluginWithVersionCandidates> settingsPluginsUpdates) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Intrinsics.checkNotNullParameter(settingsPluginsUpdates, (String)"settingsPluginsUpdates");
        StringBuilder $this$apply = stringBuilder = new StringBuilder(fileContent.length());
        boolean bl = false;
        $this$apply.append(fileContent);
        INSTANCE.removeCommentsAddedByUs$refreshVersions_core($this$apply);
        StringBuilder fileContentWithoutOurComments = stringBuilder;
        List<TaggedRange<SourceCodeSection>> ranges = GradleScriptParsingKt.extractGradleScriptSections(fileContentWithoutOurComments, isKotlinDsl);
        Iterable $this$forEach$iv = CollectionsKt.asReversed(PluginBlocksLocatingKt.findPluginBlocksRanges(fileContentWithoutOurComments, ranges));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaggedRange pluginBlockRange = (TaggedRange)element$iv;
            boolean bl2 = false;
            INSTANCE.insertAvailableVersionComments(fileContentWithoutOurComments, pluginBlockRange, isKotlinDsl, settingsPluginsUpdates);
        }
        String string2 = fileContentWithoutOurComments.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileContentWithoutOurComments.toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final void insertAvailableVersionComments(StringBuilder $this$insertAvailableVersionComments, TaggedRange<?> pluginBlockRange, boolean isKotlinDsl, List<PluginWithVersionCandidates> settingsPluginsUpdates) {
        void $this$associateByTo$iv$iv;
        Regex pluginIdRegex = isKotlinDsl ? PluginIdRegexes.INSTANCE.getKotlinDsl() : PluginIdRegexes.INSTANCE.getGroovyDsl();
        Iterable $this$associateBy$iv = settingsPluginsUpdates;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PluginWithVersionCandidates pluginWithVersionCandidates = (PluginWithVersionCandidates)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getPluginId();
            map2.put(string2, element$iv$iv);
        }
        Map pluginsUpdatesMap = destination$iv$iv;
        StringBuilder text = $this$insertAvailableVersionComments;
        String string3 = $this$insertAvailableVersionComments.substring(0, pluginBlockRange.getEndIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this.substring(0, pluginBlockRange.endIndex)");
        Iterable $this$forEach$iv = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)pluginIdRegex.findAll((CharSequence)string3, pluginBlockRange.getStartIndex())));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String availableVersionsComments;
            MatchGroup versionCallClosingParenthesisGroup;
            MatchGroup matchGroup;
            MatchGroup currentVersionGroup;
            PluginWithVersionCandidates pluginWithVersionCandidates;
            MatchGroup idGroup;
            MatchResult result2 = (MatchResult)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)result2.getGroups().get(1));
            Intrinsics.checkNotNull((Object)result2.getGroups().get(2));
            Intrinsics.checkNotNull((Object)result2.getGroups().get(3));
            String pluginId = idGroup.getValue();
            if ((PluginWithVersionCandidates)pluginsUpdatesMap.get(pluginId) == null || pluginWithVersionCandidates.getVersionsCandidates().isEmpty()) continue;
            int currentVersionStartIndex = currentVersionGroup.getRange().getFirst();
            int currentVersionEndIndex = currentVersionGroup.getRange().getLast();
            int indexOfPreviousNewLine = CharSequenceKt.indexOfPrevious($this$insertAvailableVersionComments, '\n', currentVersionStartIndex);
            int indexOfNextNewLine = StringsKt.indexOf$default((CharSequence)$this$insertAvailableVersionComments, (char)'\n', (int)currentVersionEndIndex, (boolean)false, (int)4, null);
            MatchGroup it = matchGroup = versionCallClosingParenthesisGroup;
            boolean bl2 = false;
            CharSequence charSequence = it.getValue();
            boolean shouldAddClosingParenthesis = charSequence.length() > 0 && it.getRange().getFirst() < indexOfNextNewLine;
            int offsetOfCurrentVersionFromLineStart = currentVersionStartIndex - indexOfPreviousNewLine;
            StringBuilder $this$buildString = bl2 = new StringBuilder();
            boolean bl3 = false;
            int padding = offsetOfCurrentVersionFromLineStart - 8;
            Iterable $this$forEach$iv2 = pluginWithVersionCandidates.getVersionsCandidates();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Version versionCandidate = (Version)element$iv2;
                boolean bl4 = false;
                StringBuilder stringBuilder = $this$buildString;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                $this$buildString.append("//// ");
                $this$buildString.append(StringsKt.padStart$default((String)"# available", (int)RangesKt.coerceAtLeast((int)padding, (int)0), (char)'\u0000', (int)2, null));
                $this$buildString.append(':');
                char stringLiteralDelimiter = text.charAt(currentVersionEndIndex + 1);
                $this$buildString.append(stringLiteralDelimiter);
                $this$buildString.append(versionCandidate.getValue());
                $this$buildString.append(stringLiteralDelimiter);
                if (!shouldAddClosingParenthesis) continue;
                $this$buildString.append(versionCallClosingParenthesisGroup.getValue());
            }
            Intrinsics.checkNotNullExpressionValue((Object)bl2.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            $this$insertAvailableVersionComments.insert(indexOfNextNewLine, availableVersionsComments);
            int currentVersionPadding = 19 - offsetOfCurrentVersionFromLineStart;
            if (currentVersionPadding <= 0) continue;
            $this$insertAvailableVersionComments.insert(currentVersionStartIndex - 1, StringsKt.padStart$default((String)"", (int)currentVersionPadding, (char)'\u0000', (int)2, null));
        }
    }

    public final void removeCommentsAddedByUs$refreshVersions_core(@NotNull StringBuilder $this$removeCommentsAddedByUs) {
        Intrinsics.checkNotNullParameter((Object)$this$removeCommentsAddedByUs, (String)"$this$removeCommentsAddedByUs");
        String startOfRefreshVersionsCommentLines = "\n////";
        int startIndex = 0;
        int indexOfComment;
        while ((indexOfComment = StringsKt.indexOf$default((CharSequence)$this$removeCommentsAddedByUs, (String)startOfRefreshVersionsCommentLines, (int)startIndex, (boolean)false, (int)4, null)) != -1) {
            String commentContent;
            Integer indexOfEndOfLine;
            startIndex = indexOfComment;
            Integer n = StringsKt.indexOf$default((CharSequence)$this$removeCommentsAddedByUs, (char)'\n', (int)(indexOfComment + startOfRefreshVersionsCommentLines.length()), (boolean)false, (int)4, null);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = indexOfEndOfLine = it >= 0 ? n : null;
            int endIndex = n2 != null ? n2.intValue() : $this$removeCommentsAddedByUs.length();
            int commentContentStartIndex = indexOfComment + startOfRefreshVersionsCommentLines.length();
            String string2 = commentContent = $this$removeCommentsAddedByUs.substring(commentContentStartIndex, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"commentContent");
            if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"# available", (boolean)false, (int)2, null)) {
                startIndex = endIndex;
                continue;
            }
            $this$removeCommentsAddedByUs.replace(indexOfComment, endIndex, "");
        }
        return;
    }

    private SettingsPluginsUpdater() {
    }

    static {
        SettingsPluginsUpdater settingsPluginsUpdater;
        INSTANCE = settingsPluginsUpdater = new SettingsPluginsUpdater();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/fayard/refreshVersions/core/internal/SettingsPluginsUpdater$PluginIdRegexes;", "", "()V", "groovyDsl", "Lkotlin/text/Regex;", "getGroovyDsl", "()Lkotlin/text/Regex;", "groovyStringLiteralPattern", "", "kotlinDsl", "getKotlinDsl", "kotlinStringLiteralPattern", "refreshVersions-core"})
    private static final class PluginIdRegexes {
        private static final String kotlinStringLiteralPattern = "\\\"([0-9a-zA-Z\\-\\_.]*)\\\"";
        private static final String groovyStringLiteralPattern = "[\\\"']([0-9a-zA-Z\\-\\_.]*)[\\\"']";
        @NotNull
        private static final Regex kotlinDsl;
        @NotNull
        private static final Regex groovyDsl;
        @NotNull
        public static final PluginIdRegexes INSTANCE;

        @NotNull
        public final Regex getKotlinDsl() {
            return kotlinDsl;
        }

        @NotNull
        public final Regex getGroovyDsl() {
            return groovyDsl;
        }

        private PluginIdRegexes() {
        }

        static {
            PluginIdRegexes pluginIdRegexes;
            INSTANCE = pluginIdRegexes = new PluginIdRegexes();
            String string2 = "id\\s*\\(\\s*\\\"([0-9a-zA-Z\\-\\_.]*)\\\"\\s*\\)\\s*\\.?\\s*version\\s*\\(?\\s*\\\"([0-9a-zA-Z\\-\\_.]*)\\\"\\s*(\\)?)";
            kotlinDsl = new Regex(string2);
            string2 = "id\\s*\\(?\\s*[\\\"']([0-9a-zA-Z\\-\\_.]*)[\\\"']\\s*\\)?\\s*\\.?\\s*version\\s*\\(?\\s*[\\\"']([0-9a-zA-Z\\-\\_.]*)[\\\"']\\s*(\\)?)";
            groovyDsl = new Regex(string2);
        }
    }
}

