/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.scada.ui.databinding.StyledViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewerLabelProvider
implements ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final Logger logger = LoggerFactory.getLogger(ViewerLabelProvider.class);
    private final List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    public void updateLabel(StyledViewerLabel label, Object element) {
        label.setText(element.toString());
    }

    protected final void fireChangeEvent(Collection<?> changes) {
        final LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, changes.toArray());
        final ILabelProviderListener[] listenerArray = this.listeners.toArray(new ILabelProviderListener[this.listeners.size()]);
        Display display = this.getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ILabelProviderListener[] iLabelProviderListenerArray = listenerArray;
                    int n = listenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILabelProviderListener listener = iLabelProviderListenerArray[n2];
                        try {
                            listener.labelProviderChanged(event);
                        }
                        catch (Exception e) {
                            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.core.databinding", e.getLocalizedMessage(), (Throwable)e));
                        }
                        ++n2;
                    }
                }
            });
        }
    }

    private Display getDisplay() {
        return Display.getDefault();
    }

    public final Image getImage(Object element) {
        StyledViewerLabel label = new StyledViewerLabel("", null);
        this.updateLabel(label, element);
        logger.debug("Get Image: {} for {}", new Object[]{label.getImage(), element});
        return label.getImage();
    }

    public final String getText(Object element) {
        StyledViewerLabel label = new StyledViewerLabel("", null);
        this.updateLabel(label, element);
        return label.getText();
    }

    public StyledString getStyledText(Object element) {
        StyledViewerLabel label = new StyledViewerLabel("", null);
        this.updateLabel(label, element);
        return label.getStyledText();
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.listeners.clear();
    }

    public final boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }
}

