/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.databinding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;

public abstract class ListeningStyledCellLabelProvider
extends StyledCellLabelProvider {
    private final ISetChangeListener listener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            Iterator it = event.diff.getAdditions().iterator();
            while (it.hasNext()) {
                ListeningStyledCellLabelProvider.this.addListenerTo(it.next());
            }
            it = event.diff.getRemovals().iterator();
            while (it.hasNext()) {
                ListeningStyledCellLabelProvider.this.processRemove(it.next());
            }
        }
    };
    private final IObservableSet items;
    private final Map<Object, IObservable> observables = new HashMap<Object, IObservable>();

    public ListeningStyledCellLabelProvider(IObservableSet itemsThatNeedLabels) {
        this.items = itemsThatNeedLabels;
        this.items.addSetChangeListener(this.listener);
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            this.addListenerTo(it.next());
        }
    }

    protected void listenTo(final Object element, IValueProperty property) {
        IObservableValue obs = property.observe(element);
        this.observables.put(element, (IObservable)obs);
        obs.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ListeningStyledCellLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ListeningStyledCellLabelProvider.this, element));
            }
        });
    }

    protected void processRemove(Object element) {
        IObservable obs = this.observables.remove(element);
        if (obs != null) {
            obs.dispose();
        } else {
            this.removeListenerFrom(element);
        }
    }

    public void dispose() {
        for (IObservable obs : this.observables.values()) {
            obs.dispose();
        }
        this.observables.clear();
        super.dispose();
    }

    protected abstract void removeListenerFrom(Object var1);

    protected abstract void addListenerTo(Object var1);
}

