/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services.endpoints;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.values.Endpoint;
import de.codecentric.boot.admin.server.domain.values.Endpoints;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.domain.values.Registration;
import de.codecentric.boot.admin.server.services.ApiMediaTypeHandler;
import de.codecentric.boot.admin.server.services.endpoints.EndpointDetectionStrategy;
import de.codecentric.boot.admin.server.web.client.InstanceWebClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.publisher.Mono;

public class QueryIndexEndpointStrategy
implements EndpointDetectionStrategy {
    private static final Logger log = LoggerFactory.getLogger(QueryIndexEndpointStrategy.class);
    private final InstanceWebClient instanceWebClient;
    private final ApiMediaTypeHandler apiMediaTypeHandler;

    public QueryIndexEndpointStrategy(InstanceWebClient instanceWebClient, ApiMediaTypeHandler apiMediaTypeHandler) {
        this.instanceWebClient = instanceWebClient;
        this.apiMediaTypeHandler = apiMediaTypeHandler;
    }

    @Override
    public Mono<Endpoints> detectEndpoints(Instance instance) {
        Registration registration = instance.getRegistration();
        String managementUrl = registration.getManagementUrl();
        if (managementUrl == null || Objects.equals(registration.getServiceUrl(), managementUrl)) {
            log.debug("Querying actuator-index for instance {} omitted.", (Object)instance.getId());
            return Mono.empty();
        }
        return this.instanceWebClient.instance(instance).get().uri(managementUrl, new Object[0]).exchangeToMono(this.convert(instance, managementUrl)).onErrorResume(e -> {
            log.warn("Querying actuator-index for instance {} on '{}' failed: {}", new Object[]{instance.getId(), managementUrl, e.getMessage()});
            log.debug("Querying actuator-index for instance {} on '{}' failed.", new Object[]{instance.getId(), managementUrl, e});
            return Mono.empty();
        });
    }

    protected Function<ClientResponse, Mono<Endpoints>> convert(Instance instance, String managementUrl) {
        return response -> {
            if (!response.statusCode().is2xxSuccessful()) {
                log.debug("Querying actuator-index for instance {} on '{}' failed with status {}.", new Object[]{instance.getId(), managementUrl, response.rawStatusCode()});
                return response.releaseBody().then(Mono.empty());
            }
            if (!response.headers().contentType().filter(this.apiMediaTypeHandler::isApiMediaType).isPresent()) {
                log.debug("Querying actuator-index for instance {} on '{}' failed with incompatible Content-Type '{}'.", new Object[]{instance.getId(), managementUrl, response.headers().contentType().map(Objects::toString).orElse("(missing)")});
                return response.releaseBody().then(Mono.empty());
            }
            log.debug("Querying actuator-index for instance {} on '{}' successful.", (Object)instance.getId(), (Object)managementUrl);
            return response.bodyToMono(Response.class).flatMap(this::convertResponse).map(this.alignWithManagementUrl(instance.getId(), managementUrl));
        };
    }

    protected Function<Endpoints, Endpoints> alignWithManagementUrl(InstanceId instanceId, String managementUrl) {
        return endpoints -> {
            if (!managementUrl.startsWith("https:")) {
                return endpoints;
            }
            if (endpoints.stream().noneMatch(e -> e.getUrl().startsWith("http:"))) {
                return endpoints;
            }
            log.warn("Endpoints for instance {} queried from {} are falsely using http. Rewritten to https. Consider configuring this instance to use 'server.forward-headers-strategy=native'.", (Object)instanceId, (Object)managementUrl);
            return Endpoints.of(endpoints.stream().map(e -> Endpoint.of(e.getId(), e.getUrl().replaceFirst("http:", "https:"))).collect(Collectors.toList()));
        };
    }

    protected Mono<Endpoints> convertResponse(Response response) {
        List<Endpoint> endpoints = response.getLinks().entrySet().stream().filter(e -> !((String)e.getKey()).equals("self") && !((Response.EndpointRef)e.getValue()).isTemplated()).map(e -> Endpoint.of((String)e.getKey(), ((Response.EndpointRef)e.getValue()).getHref())).collect(Collectors.toList());
        return endpoints.isEmpty() ? Mono.empty() : Mono.just((Object)Endpoints.of(endpoints));
    }

    protected static class Response {
        @JsonProperty(value="_links")
        private Map<String, EndpointRef> links = new HashMap<String, EndpointRef>();

        public Map<String, EndpointRef> getLinks() {
            return this.links;
        }

        @JsonProperty(value="_links")
        public void setLinks(Map<String, EndpointRef> links) {
            this.links = links;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, EndpointRef> this$links = this.getLinks();
            Map<String, EndpointRef> other$links = other.getLinks();
            return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, EndpointRef> $links = this.getLinks();
            result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
            return result;
        }

        public String toString() {
            return "QueryIndexEndpointStrategy.Response(links=" + this.getLinks() + ")";
        }

        protected static class EndpointRef {
            private final String href;
            private final boolean templated;

            @JsonCreator
            EndpointRef(@JsonProperty(value="href") String href, @JsonProperty(value="templated") boolean templated) {
                this.href = href;
                this.templated = templated;
            }

            public String getHref() {
                return this.href;
            }

            public boolean isTemplated() {
                return this.templated;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof EndpointRef)) {
                    return false;
                }
                EndpointRef other = (EndpointRef)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isTemplated() != other.isTemplated()) {
                    return false;
                }
                String this$href = this.getHref();
                String other$href = other.getHref();
                return !(this$href == null ? other$href != null : !this$href.equals(other$href));
            }

            protected boolean canEqual(Object other) {
                return other instanceof EndpointRef;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isTemplated() ? 79 : 97);
                String $href = this.getHref();
                result = result * 59 + ($href == null ? 43 : $href.hashCode());
                return result;
            }

            public String toString() {
                return "QueryIndexEndpointStrategy.Response.EndpointRef(href=" + this.getHref() + ", templated=" + this.isTemplated() + ")";
            }
        }
    }
}

