/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.config;

import de.codecentric.boot.admin.client.config.ClientProperties;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class SpringBootAdminClientEnabledCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata annotatedTypeMetadata) {
        ClientProperties clientProperties = this.getClientProperties(context);
        if (!clientProperties.isEnabled()) {
            return ConditionOutcome.noMatch((String)"Spring Boot Client is disabled, because 'spring.boot.admin.client.enabled' is false.");
        }
        if (clientProperties.getUrl().length == 0) {
            return ConditionOutcome.noMatch((String)"Spring Boot Client is disabled, because 'spring.boot.admin.client.url' is empty.");
        }
        return ConditionOutcome.match();
    }

    private ClientProperties getClientProperties(ConditionContext context) {
        ClientProperties clientProperties = new ClientProperties();
        Binder.get((Environment)context.getEnvironment()).bind("spring.boot.admin.client", Bindable.ofInstance((Object)clientProperties));
        return clientProperties;
    }
}

