/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher.outgoing;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRequestScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosTarget;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class ChaosMonkeyWebClientWatcher
implements ExchangeFilterFunction {
    private final ChaosMonkeyRequestScope chaosMonkeyRequestScope;
    private final WatcherProperties watcherProperties;
    private static final String ALREADY_FILTERED_SUFFIX = ".FILTERED";

    public ChaosMonkeyWebClientWatcher(ChaosMonkeyRequestScope chaosMonkeyRequestScope, WatcherProperties watcherProperties) {
        this.chaosMonkeyRequestScope = chaosMonkeyRequestScope;
        this.watcherProperties = watcherProperties;
    }

    public Mono<ClientResponse> filter(ClientRequest clientRequest, ExchangeFunction exchangeFunction) {
        RequestFilterWrapper requestFilterWrapper = this.handleOncePerRequest(clientRequest);
        Mono response = exchangeFunction.exchange(requestFilterWrapper.clientRequest);
        if (requestFilterWrapper.filter.booleanValue() && this.watcherProperties.isWebClient()) {
            response = response.map(clientResponse -> {
                this.chaosMonkeyRequestScope.callChaosMonkey(ChaosTarget.WEB_CLIENT, clientRequest.url().toString());
                return clientResponse;
            });
        }
        return response;
    }

    private RequestFilterWrapper handleOncePerRequest(ClientRequest clientRequest) {
        ClientRequest request;
        Boolean filter;
        String filterName = this.getClass().getName() + ALREADY_FILTERED_SUFFIX;
        if (clientRequest.attribute(filterName).isPresent()) {
            filter = Boolean.FALSE;
            request = clientRequest;
        } else {
            filter = Boolean.TRUE;
            request = ClientRequest.from((ClientRequest)clientRequest).attribute(filterName, (Object)Boolean.TRUE).build();
        }
        return new RequestFilterWrapper(request, filter);
    }

    private record RequestFilterWrapper(ClientRequest clientRequest, Boolean filter) {
    }
}

