/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.assaults;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRuntimeAssault;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class KillAppAssault
implements ChaosMonkeyRuntimeAssault,
ApplicationContextAware {
    private static final Logger Logger = LoggerFactory.getLogger(KillAppAssault.class);
    private final ChaosMonkeySettings settings;
    private ApplicationContext context;
    private final MetricEventPublisher metricEventPublisher;

    public KillAppAssault(ChaosMonkeySettings settings, MetricEventPublisher metricEventPublisher) {
        this.settings = settings;
        this.metricEventPublisher = metricEventPublisher;
    }

    @Override
    public boolean isActive() {
        return this.settings.getAssaultProperties().isKillApplicationActive();
    }

    @Override
    public void attack() {
        try {
            Logger.info("Chaos Monkey - I am killing your Application!");
            if (this.metricEventPublisher != null) {
                this.metricEventPublisher.publishMetricEvent(MetricType.KILLAPP_ASSAULT, new String[0]);
            }
            int exit = SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
            long remaining = 5000L;
            long end = System.currentTimeMillis() + remaining;
            while (true) {
                try {
                    TimeUnit.MILLISECONDS.sleep(remaining);
                }
                catch (InterruptedException ignored) {
                    remaining = end - System.currentTimeMillis();
                    continue;
                }
                break;
            }
            System.exit(exit);
        }
        catch (Exception e) {
            Logger.info("Chaos Monkey - Unable to kill the App, I am not the BOSS!");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    @Override
    public String getCronExpression(AssaultProperties assaultProperties) {
        return assaultProperties.getKillApplicationCronExpression();
    }
}

