/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher.advice;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRequestScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosTarget;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.ChaosMonkeyDefaultAdvice;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.filter.SpringHookMethodsFilter;
import java.util.Map;
import java.util.WeakHashMap;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.AbstractAdvisingBeanPostProcessor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;

public class ChaosMonkeyBeanPostProcessor
extends AbstractAdvisingBeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ChaosMonkeyBeanPostProcessor.class);
    private final WatcherProperties watcherProperties;
    private final Map<Object, String> activeBeanNameCache = new WeakHashMap<Object, String>();

    public ChaosMonkeyBeanPostProcessor(WatcherProperties watcherProperties, ChaosMonkeyRequestScope requestScope, MetricEventPublisher eventPublisher) {
        this.watcherProperties = watcherProperties;
        ChaosMonkeyDefaultAdvice advice = new ChaosMonkeyDefaultAdvice(requestScope, eventPublisher, ChaosTarget.BEAN, pjp -> watcherProperties.getBeans().contains(this.activeBeanNameCache.get(pjp.getThis())));
        this.advisor = new DefaultPointcutAdvisor((Pointcut)new ComposablePointcut((MethodMatcher)SpringHookMethodsFilter.INSTANCE), (Advice)advice);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (this.watcherProperties.getBeans().contains(beanName)) {
            Object proxy = super.postProcessAfterInitialization(bean, beanName);
            this.activeBeanNameCache.put(proxy, beanName);
            return proxy;
        }
        return bean;
    }
}

