/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import com.sun.management.OperatingSystemMXBean;
import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRequestAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRuntimeAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.CpuAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.ExceptionAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.KillAppAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.LatencyAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.MemoryAssault;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRequestScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRuntimeScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyScheduler;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.Metrics;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeyAdvisorConfiguration;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeyCondition;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeyOpenApiConfiguration;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeyProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeyRestTemplateConfiguration;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeyWebClientConfiguration;
import de.codecentric.spring.boot.chaos.monkey.configuration.UnleashChaosConfiguration;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.toggles.ChaosToggleNameMapper;
import de.codecentric.spring.boot.chaos.monkey.configuration.toggles.ChaosToggles;
import de.codecentric.spring.boot.chaos.monkey.configuration.toggles.DefaultChaosToggleNameMapper;
import de.codecentric.spring.boot.chaos.monkey.configuration.toggles.DefaultChaosToggles;
import de.codecentric.spring.boot.chaos.monkey.endpoints.ChaosMonkeyJmxEndpoint;
import de.codecentric.spring.boot.chaos.monkey.endpoints.ChaosMonkeyRestEndpoint;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.util.StreamUtils;

@AutoConfiguration
@Conditional(value={ChaosMonkeyCondition.class})
@EnableConfigurationProperties(value={ChaosMonkeyProperties.class, AssaultProperties.class, WatcherProperties.class})
@Import(value={UnleashChaosConfiguration.class, ChaosMonkeyWebClientConfiguration.class, ChaosMonkeyRestTemplateConfiguration.class, ChaosMonkeyAdvisorConfiguration.class, ChaosMonkeyOpenApiConfiguration.class})
@EnableScheduling
public class ChaosMonkeyConfiguration {
    private static final Logger Logger = LoggerFactory.getLogger(ChaosMonkeyConfiguration.class);
    private static final String CHAOS_MONKEY_TASK_SCHEDULER = "chaosMonkeyTaskScheduler";
    private final ChaosMonkeyProperties chaosMonkeyProperties;
    private final WatcherProperties watcherProperties;
    private final AssaultProperties assaultProperties;

    public ChaosMonkeyConfiguration(ChaosMonkeyProperties chaosMonkeyProperties, WatcherProperties watcherProperties, AssaultProperties assaultProperties) {
        this.chaosMonkeyProperties = chaosMonkeyProperties;
        this.watcherProperties = watcherProperties;
        this.assaultProperties = assaultProperties;
        try {
            String chaosLogo = StreamUtils.copyToString((InputStream)new ClassPathResource("chaos-logo.txt").getInputStream(), (Charset)Charset.defaultCharset());
            Logger.info(chaosLogo);
        }
        catch (IOException e) {
            Logger.info("Chaos Monkey - ready to do evil");
        }
    }

    @Bean
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    public Metrics metrics() {
        return new Metrics();
    }

    @Bean
    public MetricEventPublisher publisher() {
        return new MetricEventPublisher();
    }

    @Bean
    public ChaosMonkeySettings settings() {
        return new ChaosMonkeySettings(this.chaosMonkeyProperties, this.assaultProperties, this.watcherProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public LatencyAssault latencyAssault(ChaosMonkeySettings settings, MetricEventPublisher publisher) {
        return new LatencyAssault(settings, publisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionAssault exceptionAssault(ChaosMonkeySettings settings, MetricEventPublisher publisher) {
        return new ExceptionAssault(settings, publisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public KillAppAssault killAppAssault(ChaosMonkeySettings settings, MetricEventPublisher publisher) {
        return new KillAppAssault(settings, publisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public MemoryAssault memoryAssault(ChaosMonkeySettings settings, MetricEventPublisher publisher) {
        return new MemoryAssault(Runtime.getRuntime(), settings, publisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public CpuAssault cpuAssault(ChaosMonkeySettings settings, MetricEventPublisher publisher) {
        return new CpuAssault(ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class), settings, publisher);
    }

    @Bean
    public ChaosMonkeyRequestScope chaosMonkeyRequestScope(List<ChaosMonkeyRequestAssault> chaosMonkeyAssaults, List<ChaosMonkeyAssault> allAssaults, ChaosToggles chaosToggles, ChaosToggleNameMapper chaosToggleNameMapper, ChaosMonkeySettings settings, MetricEventPublisher publisher) {
        return new ChaosMonkeyRequestScope(settings, chaosMonkeyAssaults, allAssaults, publisher, chaosToggles, chaosToggleNameMapper);
    }

    @Bean
    @ConditionalOnMissingBean(value={ChaosToggleNameMapper.class})
    public ChaosToggleNameMapper chaosToggleNameMapper(ChaosMonkeyProperties chaosMonkeyProperties) {
        return new DefaultChaosToggleNameMapper(chaosMonkeyProperties.getTogglePrefix());
    }

    @Bean
    @ConditionalOnMissingBean(value={ChaosToggles.class})
    public ChaosToggles chaosToggles() {
        return new DefaultChaosToggles();
    }

    @Bean
    public ChaosMonkeyScheduler chaosMonkeyScheduler(@Qualifier(value="chaosMonkeyTaskScheduler") TaskScheduler scheduler, List<ChaosMonkeyRuntimeAssault> assaults) {
        ScheduledTaskRegistrar registrar = new ScheduledTaskRegistrar();
        registrar.setTaskScheduler(scheduler);
        return new ChaosMonkeyScheduler(registrar, this.assaultProperties, assaults);
    }

    @Bean(name={"chaosMonkeyTaskScheduler"})
    public TaskScheduler chaosMonkeyTaskScheduler() {
        return new ThreadPoolTaskScheduler();
    }

    @Bean
    public ChaosMonkeyRuntimeScope chaosMonkeyRuntimeScope(ChaosMonkeySettings settings, List<ChaosMonkeyRuntimeAssault> chaosMonkeyAssaults) {
        return new ChaosMonkeyRuntimeScope(settings, chaosMonkeyAssaults);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    public ChaosMonkeyRestEndpoint chaosMonkeyRestEndpoint(ChaosMonkeySettings settings, ChaosMonkeyRuntimeScope runtimeScope, ChaosMonkeyScheduler scheduler) {
        return new ChaosMonkeyRestEndpoint(settings, runtimeScope, scheduler);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    public ChaosMonkeyJmxEndpoint chaosMonkeyJmxEndpoint(ChaosMonkeySettings settings) {
        return new ChaosMonkeyJmxEndpoint(settings);
    }
}

