/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.endpoints;

import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.endpoints.dto.AssaultPropertiesUpdate;
import de.codecentric.spring.boot.chaos.monkey.endpoints.dto.ChaosMonkeyDisabledDto;
import de.codecentric.spring.boot.chaos.monkey.endpoints.dto.ChaosMonkeyEnabledDto;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.jmx.annotation.JmxEndpoint;

@JmxEndpoint(enableByDefault=false, id="chaosmonkeyjmx")
public class ChaosMonkeyJmxEndpoint {
    private final ChaosMonkeySettings chaosMonkeySettings;

    public ChaosMonkeyJmxEndpoint(ChaosMonkeySettings chaosMonkeySettings) {
        this.chaosMonkeySettings = chaosMonkeySettings;
    }

    @ReadOperation
    public AssaultPropertiesUpdate getAssaultProperties() {
        return this.chaosMonkeySettings.getAssaultProperties().toDto();
    }

    @WriteOperation
    public String toggleLatencyAssault() {
        this.chaosMonkeySettings.getAssaultProperties().setLatencyActive(this.getAssaultProperties().getLatencyActive() == false);
        return String.valueOf(this.getAssaultProperties().getLatencyActive());
    }

    @WriteOperation
    public String toggleExceptionAssault() {
        this.chaosMonkeySettings.getAssaultProperties().setExceptionsActive(this.getAssaultProperties().getExceptionsActive() == false);
        return String.valueOf(this.getAssaultProperties().getExceptionsActive());
    }

    @WriteOperation
    public String toggleKillApplicationAssault() {
        this.chaosMonkeySettings.getAssaultProperties().setKillApplicationActive(this.getAssaultProperties().getKillApplicationActive() == false);
        return String.valueOf(this.getAssaultProperties().getKillApplicationActive());
    }

    @WriteOperation
    public String toggleCpuAssault() {
        this.chaosMonkeySettings.getAssaultProperties().setCpuActive(this.getAssaultProperties().getCpuActive() == false);
        return String.valueOf(this.getAssaultProperties().getCpuActive());
    }

    @ReadOperation
    public String isChaosMonkeyActive() {
        return String.valueOf(this.chaosMonkeySettings.getChaosMonkeyProperties().isEnabled());
    }

    @WriteOperation
    public ChaosMonkeyEnabledDto enableChaosMonkey() {
        this.chaosMonkeySettings.getChaosMonkeyProperties().setEnabled(true);
        return new ChaosMonkeyEnabledDto();
    }

    @WriteOperation
    public ChaosMonkeyDisabledDto disableChaosMonkey() {
        this.chaosMonkeySettings.getChaosMonkeyProperties().setEnabled(false);
        return new ChaosMonkeyDisabledDto();
    }

    @ReadOperation
    public WatcherProperties getWatcherProperties() {
        return this.chaosMonkeySettings.getWatcherProperties();
    }
}

