/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="chaos.monkey.assaults.exception")
public class AssaultException {
    private static final Logger Logger = LoggerFactory.getLogger(AssaultException.class);
    @Value(value="${type : java.lang.RuntimeException}")
    private String type;
    @Value(value="${arguments : #{null}}")
    private List<ExceptionArgument> arguments;

    public List<ExceptionArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<ExceptionArgument> arguments) {
        this.arguments = arguments;
    }

    @JsonIgnore
    public void throwExceptionInstance() {
        Throwable instance;
        try {
            Class<? extends Throwable> exceptionClass = this.getExceptionClass();
            if (this.arguments == null) {
                Constructor<? extends Throwable> constructor = exceptionClass.getConstructor(new Class[0]);
                instance = constructor.newInstance(new Object[0]);
            } else {
                Constructor<? extends Throwable> constructor = exceptionClass.getConstructor(this.getExceptionArgumentTypes().toArray(new Class[0]));
                instance = constructor.newInstance(this.getExceptionArgumentValues().toArray(new Object[0]));
            }
        }
        catch (ReflectiveOperationException e) {
            Logger.warn("Cannot instantiate the class for provided type: {}. Fallback: Throw RuntimeException", (Object)this.type);
            instance = new RuntimeException("Chaos Monkey - RuntimeException");
        }
        throw instance;
    }

    @JsonIgnore
    public Class<? extends Throwable> getExceptionClass() throws ClassNotFoundException {
        if (this.type == null) {
            this.type = "java.lang.RuntimeException";
            ExceptionArgument exceptionArgument = new ExceptionArgument();
            exceptionArgument.setClassName("java.lang.String");
            exceptionArgument.setValue("Chaos Monkey - RuntimeException");
            this.arguments = Collections.singletonList(exceptionArgument);
        }
        return Class.forName(this.type).asSubclass(Throwable.class);
    }

    @JsonIgnore
    public List<Class> getExceptionArgumentTypes() {
        return this.arguments.stream().map(ExceptionArgument::getClassType).collect(Collectors.toList());
    }

    @JsonIgnore
    private List<Object> getExceptionArgumentValues() {
        return this.arguments.stream().map(ExceptionArgument::getValue).collect(Collectors.toList());
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssaultException)) {
            return false;
        }
        AssaultException other = (AssaultException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<ExceptionArgument> this$arguments = this.getArguments();
        List<ExceptionArgument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssaultException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<ExceptionArgument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    public String toString() {
        return "AssaultException(type=" + this.getType() + ", arguments=" + this.getArguments() + ")";
    }

    public static class ExceptionArgument {
        @NotNull
        private String className;
        @NotNull
        private String value;

        @JsonIgnore
        public Class<?> getClassType() {
            try {
                return Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found for class name: " + this.className);
            }
        }

        public String getClassName() {
            return this.className;
        }

        public String getValue() {
            return this.value;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExceptionArgument)) {
                return false;
            }
            ExceptionArgument other = (ExceptionArgument)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExceptionArgument;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "AssaultException.ExceptionArgument(className=" + this.getClassName() + ", value=" + this.getValue() + ")";
        }
    }
}

