/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.assaults;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyLatencyAssaultExecutor;
import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRequestAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.LatencyAssaultExecutor;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyAssault
implements ChaosMonkeyRequestAssault {
    private static final Logger Logger = LoggerFactory.getLogger(LatencyAssault.class);
    private final ChaosMonkeySettings settings;
    private final ChaosMonkeyLatencyAssaultExecutor assaultExecutor;
    private MetricEventPublisher metricEventPublisher;
    private AtomicInteger atomicTimeoutGauge;

    public LatencyAssault(ChaosMonkeySettings settings, MetricEventPublisher metricEventPublisher, ChaosMonkeyLatencyAssaultExecutor executor) {
        this.settings = settings;
        this.metricEventPublisher = metricEventPublisher;
        this.atomicTimeoutGauge = new AtomicInteger(0);
        this.assaultExecutor = executor;
    }

    public LatencyAssault(ChaosMonkeySettings settings, MetricEventPublisher metricEventPublisher) {
        this(settings, metricEventPublisher, new LatencyAssaultExecutor());
    }

    @Override
    public boolean isActive() {
        return this.settings.getAssaultProperties().isLatencyActive();
    }

    @Override
    public void attack() {
        Logger.debug("Chaos Monkey - timeout");
        this.atomicTimeoutGauge.set(this.determineLatency());
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.publishMetricEvent(MetricType.LATENCY_ASSAULT, new String[0]);
            this.metricEventPublisher.publishMetricEvent(MetricType.LATENCY_ASSAULT, this.atomicTimeoutGauge);
        }
        this.assaultExecutor.execute(this.atomicTimeoutGauge.get());
    }

    private int determineLatency() {
        int latencyRangeEnd;
        int latencyRangeStart = this.settings.getAssaultProperties().getLatencyRangeStart();
        if (latencyRangeStart == (latencyRangeEnd = this.settings.getAssaultProperties().getLatencyRangeEnd())) {
            return latencyRangeStart;
        }
        return ThreadLocalRandom.current().nextInt(latencyRangeStart, latencyRangeEnd);
    }
}

